<?php
namespace BricksUltimate\Trait;

if ( ! defined( 'ABSPATH' ) ) exit;

trait WpElements {
	private $doc = \BricksUltimate\Plugin::BU_SITE_URL . 'doc';
	/**
	 * Gets all standard elements
	 * 
	 * @return array $elements
	 */
	public function get_elements() {
		$elements = [
			'burger' => [
				'name' 	=> __('Animated Burger', 'bricksultimate'),
				'file' 	=> 'AnimatedBurger.php',
				'link' 	=> $this->doc . '/animated-burger/'
			],
			'acrdmenu' => [
				'name' 	=> __('Accordion Menu', 'bricksultimate'),
				'file' 	=> 'AccordionMenu.php',
				'link' 	=> $this->doc . '/accordion-menu/'
			],
			'ajaxsearch' => [
				'name' 	=> __('Ajax Search Form', 'bricksultimate'),
				'file' 	=> 'AjaxSearch.php',
				'link' 	=> $this->doc . '/ajax-search-form/'
			],
			'backtop' 	=> [
				'name' 	=> __('Back To Top', 'bricksultimate'),
				'file' 	=> 'BackToTop.php',
				'link' 	=> $this->doc . '/back-to-top/'
			],
			'baimg' 	=> [
				'name' 	=> __('Before After Image', 'bricksultimate'),
				'file' 	=> 'BeforeAfterImage.php',
				'link' 	=> $this->doc . '/before-after-image/'
			],
			'bcrumbs' 	=> [
				'name' 	=> __('Breadcrumbs', 'bricksultimate'),
				'file' 	=> 'Breadcrumbs.php',
				'show' 	=> $this->checkSeoPlugin(),
				'link' 	=> $this->doc . '/breadcrumbs/'
			],
			'buh' 		=> [
				'name' 	=> __('Business Hours', 'bricksultimate'),
				'file' 	=> 'BusinessHours.php',
				'link' 	=> $this->doc . '/business-hours/'
			],
			'bdge' => [
				'name' 	=> __('Badge', 'bricksultimate'),
				'file' 	=> 'WooNewBadge.php',
				'link' 	=> '#'
			],
			'compare' => [
				'name' 	=> __('Compare', 'bricksultimate'),
				'file' 	=> '#',
				'link' 	=> $this->doc . '/compare/',
			],
			'cgrid' 	=> [
				'name' 	=> __('CSS Grid Layouts', 'bricksultimate'),
				'file' 	=> '#',
				'link' 	=> $this->doc . '/inbuilt-css-grid-templates/'
			],
			'cf7' => [
				'name' 	=> __('Contact Form 7 Styler', 'bricksultimate'),
				'file' 	=> 'ContactFormStyler.php',
				'show' 	=> ( ! class_exists( 'WPCF7' ) ) ? false : true,
				'link' 	=> $this->doc . '/contact-form-7-styler/'
			],
			'cdt' => [
				'name' 	=> __('Countdown', 'bricksultimate'),
				'file' 	=> 'Countdown.php',
				'link' 	=> $this->doc . '/countdown/'
			],
			'wpquerypagination' => [
				'name' 	=> __('Pagination for Custom WP Query Loop Builder', 'bricksultimate'),
				'file' 	=> 'WpQueryPagination.php',
				'link' 	=> '#',
			],
			'dualhd' => [
				'name' 	=> __('Dual Color Text', 'bricksultimate'),
				'file' 	=> 'DualColorHeading.php',
				'link' 	=> $this->doc . '/dual-color-text/'
			],
			'flexgal' => [
				'name' 	=> __('Flex Gallery', 'bricksultimate'),
				'file' 	=> 'FlexGallery.php',
				'link' 	=> $this->doc . '/flex-gallery/'
			],
			'ffs' => [
				'name' 	=> __('Fluent Forms Styler', 'bricksultimate'),
				'file' 	=> 'FluentFormsStyler.php',
				'show' 	=> ( ! function_exists( 'wpFluentForm' ) ) ? false : true,
				'link' 	=> $this->doc . '/fluent-forms-styler/'
			],
			'gfs' => [
				'name' 	=> __('Gravity Forms Styler', 'bricksultimate'),
				'file' 	=> 'GravityFormsStyler.php',
				'show' 	=> ( ! class_exists( 'GFForms' ) ) ? false : true,
				'link' 	=> $this->doc . '/gravity-forms-styler/'
			],
			'hlhd' => [
				'name' 	=> __('Highlighted Heading', 'bricksultimate'),
				'file' 	=> 'HighlightedHeading.php',
				'link' 	=> $this->doc . '/highlighted-heading/'
			],
			'imgmedia' => [
				'name' 	=> __('Image Attachment', 'bricksultimate'),
				'file' 	=> 'ImageMedia.php',
				'link' 	=> $this->doc . '/image-media/'
			],
			'pbar' => [
				'name' 	=> __('Reading Progress Bar', 'bricksultimate'),
				'file' 	=> 'ReadingProgressBar.php',
				'link' 	=> $this->doc . '/reading-progress-bar/'
			],
			'ofc' => [
				'name' 	=> __('Off Canvas', 'bricksultimate'),
				'file' 	=> 'OffCanvas.php',
				'link' 	=> $this->doc . '/off-canvas/'
			],
			'pfs' => [
				'name' 	=> __('Piotnet Forms Styler', 'bricksultimate'),
				'file' 	=> 'PiotnetFormsStyler.php',
				'show' 	=> ( ! class_exists( 'Piotnetforms' ) && ! class_exists( 'Piotnetforms_pro' ) ) ? false : true,
				'link' 	=> $this->doc . '/piotnet-forms-styler/'
			],
			'postterms' => [
				'name' 	=> __('Post Terms', 'bricksultimate'),
				'file' 	=> 'PostTerms.php',
				'link' 	=> $this->doc . '/post-terms/'
			],
			'pgrid' => [
				'name' 	=> __('Post Grid', 'bricksultimate'),
				'file' 	=> 'PostGrid.php',
				'link' 	=> $this->doc . '/post-grid/'
			],
			'sldarrow' => [
				'name' 	=> __('Slider(Nestable) Arrows', 'bricksultimate'),
				'file' 	=> 'SliderArrows.php',
				'link' 	=> $this->doc . '/nested-slider-arrow/'
			],
			'sldpb' => [
				'name' 	=> __('Slider(Nestable) Progress Bar', 'bricksultimate'),
				'file' => 'SliderProgressBar.php',
				'link' 	=> $this->doc . '/nested-slider-progress-bar/'
			],
			'sldmenu' => [
				'name' 	=> __('Sliding Menu', 'bricksultimate'),
				'file' 	=> 'SlidingMenu.php',
				'link' 	=> $this->doc . '/sliding-menu/'
			],
			'slimgal' => [
				'name' 	=> __('Slim Gallery', 'bricksultimate'),
				'file' 	=> 'SlimGallery.php',
				'link' 	=> 'https://youtu.be/_0oApreCVIk'
			],
			'stars' => [
				'name' 	=> __('Star Ratings', 'bricksultimate'),
				'file' => 'StarRating.php',
				'link' 	=> $this->doc . '/star-rating/'
			],
			'table' => [
				'name' 	=> __('Table (Grid)', 'bricksultimate'),
				'file' => 'TableGrid.php',
				'link' 	=> $this->doc . '/table-grid-view/'
			],
			'simtable' => [
				'name' 	=> __('Table', 'bricksultimate'),
				'file' => 'Table.php',
				'link' 	=> $this->doc . '/table/'
			],
			'wsl' => [
				'name' 	=> __('Wishlist', 'bricksultimate'),
				'file' 	=> '#',
				'link' 	=> $this->doc . '/wishlist/'
			],
			'wpfs' => [
				'name' 	=> __('WPForms Styler', 'bricksultimate'),
				'file' 	=> 'WpFormsStyler.php',
				'show' 	=> ( ! class_exists( 'WPForms_Pro' ) && ! class_exists( 'WPForms_Lite' ) ) ? false : true,
				'link' 	=> $this->doc . '/wpforms-styler/'
			],
			'wsfs' => [
				'name' 	=> __('WSForms Styler', 'bricksultimate'),
				'file' 	=> 'WSFormsStyler.php',
				'show' 	=> ( ! class_exists('WS_Form_Form') ) ? false : true,
				'link' 	=> $this->doc . '/wsforms-styler/'
			],
		];

		return $elements;
	}

	private function checkSeoPlugin( $bool = false ) {
		if (function_exists( 'aioseo_breadcrumbs' ) ) {
			$bool = true;
		} elseif ( function_exists('bcn_display') ) {
			$bool = true;
		} elseif ( function_exists( 'rank_math_the_breadcrumbs' ) ) {
			$bool = true;
		} elseif ( function_exists( 'seopress_display_breadcrumbs' ) ) {
			$bool = true;
		} elseif ( class_exists( '\SlimSEO\Breadcrumbs' ) ) {
			$bool = true;
		} elseif ( function_exists( 'yoast_breadcrumb' ) ) {
			$bool = true;
		} elseif ( function_exists( 'zynith_seo_breadcrumbs' ) ) {
			$bool = true;
		} else {
			$bool = false;
		}

		return $bool;
	}
}