<?php
namespace BricksUltimate\WooCommerce;

if ( ! defined( 'ABSPATH' ) ) exit;

class Swatches {
	public static function bu_get_swatches( $id, $attr_name, $options, $variations ) {
		$swatches = [];

		foreach ( $options as $key => $value ) {
			$swatch = self::bu_get_attr_swatch( $id, $attr_name, $value );

			if ( ! empty( $swatch ) ) {

				if ( $variations ) {
					$variation = self::bu_get_product_variations_images( $attr_name, $variations, $value );
					$swatch = array_merge( $swatch, $variation ?? [] );
				}

				$swatches[ $key ] = $swatch;
			} else if ( taxonomy_exists( $attr_name ) && $variations ) {
				$variation = self::bu_get_product_variations_images( $attr_name, $variations, $value );
				$swatches[ $key ] = $variation;
			} else {
				$swatches[ $key ] = self::bu_get_attr_swatch( 0, $attr_name, $value );;
			}
		}

		return $swatches;
	}

	public static function bu_get_attr_swatch( $id, $attr_name, $value ) {
		$swatches = [];
		$color = $image_id = $bbcolor = $bbimg_id = $label_text = '';

		$term = get_term_by( 'slug', $value, $attr_name );
		if ( is_object( $term ) ) {
			$color 		= get_term_meta( $term->term_id, 'bu_swatches_color', true );
			$image_id 	= get_term_meta( $term->term_id, 'bu_swatches_img_id', true );

			$bbcolor 	= get_term_meta( $term->term_id, 'bricks_swatch_color_value', true );
			$bbimg_id 	= get_term_meta( $term->term_id, 'bricks_swatch_image_value', true );
		}

		if ( $color != '' ) {
			$swatches['color'] = $color;
		} elseif( $bbcolor != '' ) {
			$swatches['color'] = esc_attr( $bbcolor );
		}

		if ( $image_id != '' ) {
			$swatches['image'] = wp_get_attachment_image_url( $image_id, 'full' );
		} elseif ( $bbimg_id != '' ) {
			$swatches['image'] = wp_get_attachment_image_url( $bbimg_id, 'full' );
		}

		if ( empty( $color ) && empty( $image_id ) && taxonomy_exists( $attr_name ) ) {
			$label_text = get_term_meta( $term->term_id, 'bricks_swatch_label_value', true );
			$swatches['org'] = ( $label_text != '' ) ? esc_attr( $label_text ) : $term->name;
		}

		return $swatches;
	}

	public static function bu_get_product_variations_images( $attribute_name, $available_variations, $option = false, $product_id = false ) {
		$swatches = [];
		$product_image_id = get_post_thumbnail_id( $product_id );

		foreach ( $available_variations as $key => $variation ) {
			$option_variation = [];
			$attr_key         = 'attribute_' . $attribute_name;

			if ( ! isset( $variation['attributes'][ $attr_key ] ) ) {
				return;
			}

			$val = $variation['attributes'][ $attr_key ];

			if ( ! empty( $variation['image']['src'] ) ) {
				$option_variation = [
					'variation_id' => $variation['variation_id'],
					'is_in_stock'  => $variation['is_in_stock'],
					'image_src'  => $variation['image']['src'],
					'image_srcset'  => $variation['image']['srcset'],
					'image_sizes'  => $variation['image']['sizes'],
				];
			}

			if ( $option ) {
				if ( $val != $option ) {
					continue;
				} else {
					return $option_variation;
				}
			} else {
				$swatch = self::bu_get_attr_swatch( $product_id, $attribute_name, $val );
				$swatches[ $val ] = array_merge( $swatch, $option_variation );
			}
		}

		return $swatches;
	}

	public static function bu_get_selected_variations( $attribute_name, $available_variations ) {
		$selected_variations = [];

		if ( ! $available_variations ) {
			return $selected_variations;
		}

		foreach ( $available_variations as $variation ) {
			$attr_key = 'attribute_' . $attribute_name;
			if ( isset( $variation['attributes'][ $attr_key ] ) ) {
				$selected_variations[] = $variation['attributes'][ $attr_key ];
			}
		}

		return $selected_variations;
	}
}