<?php
defined( 'ABSPATH' ) || exit;

global $product;

$attribute_keys  = array_keys( $attributes );
$variations_json = wp_json_encode( $available_variations );
$variations_attr = function_exists( 'wc_esc_json' ) ? wc_esc_json( $variations_json ) : _wp_specialchars( $variations_json, ENT_QUOTES, 'UTF-8', true );
?>

<form class="variations_form cart" action="<?php echo esc_url( apply_filters( 'woocommerce_add_to_cart_form_action', $product->get_permalink() ) ); ?>" method="post" enctype='multipart/form-data' data-product_id="<?php echo absint( $product->get_id() ); ?>" data-product_variations="<?php echo $variations_attr; // WPCS: XSS ok. ?>">

	<?php if ( empty( $available_variations ) && false !== $available_variations ) : ?>
		<p class="stock out-of-stock"><?php echo esc_html( apply_filters( 'woocommerce_out_of_stock_message', __( 'This product is currently out of stock and unavailable.', 'woocommerce' ) ) ); ?></p>
	<?php else : ?>
		<table class="variations" cellspacing="0" role="presentation">
			<tbody>
				<?php 
					foreach ( $attributes as $attribute_name => $options ) :
						$swatches = \BricksUltimate\WooCommerce\Swatches::bu_get_swatches( $product->get_id(), $attribute_name, $options, $available_variations);
						$selected_variations = \BricksUltimate\WooCommerce\Swatches::bu_get_selected_variations( $attribute_name, $available_variations );
				?>
					<tr>
						<th class="label">
							<label for="<?php echo esc_attr( sanitize_title( $attribute_name ) ); ?>"><?php echo wc_attribute_label( $attribute_name ); ?>: <span class="bu-swatch-selected"></span>
							</label>	
						</th>
						<td class="value<?php if ( ! empty( $swatches ) ): ?> has-swatches<?php endif; ?>">
							<?php 
								if ( ! empty( $swatches ) ):
									include $path . 'single-product/add-to-cart/view-swatches.php';
								endif;

								wc_dropdown_variation_attribute_options(
									array(
										'options'   => $options,
										'attribute' => $attribute_name,
										'product'   => $product,
									)
								);

								$clearText = \BricksUltimate\Helpers::get_value( $settings, '_clrBtnText' ); 

								$icon = '';
								if( ! empty( $settings['_clrBtnIcon'] ) )
									$icon = \Bricks\Element::render_icon( $settings['_clrBtnIcon'], [ 'reset-btn-icon' ] );

								if ( ! empty( $swatches ) ):
									echo '<div class="sw-reset-button">';
								endif;
								echo end( $attribute_keys ) === $attribute_name ? wp_kses_post( apply_filters( 'woocommerce_reset_variations_link', '<a class="reset_variations" href="#">' . $clearText . $icon . '</a>' ) ) : '';
								if ( ! empty( $swatches ) ):
									echo '</div">';
								endif;
							?>
						</td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>

		<div class="single_variation_wrap">
			<?php woocommerce_single_variation_add_to_cart_button(); ?>
		</div>
	<?php endif; ?>
</form>