<?php
/**
 * Swatches
 *
 * @package BricksUltimate\Templates
 * @version 1.0
 */

defined( 'ABSPATH' ) || exit;

global $product;
?>

<div class="swatches-select bu-swatches" data-id="<?php echo esc_attr( sanitize_title( $attribute_name ) ); ?>">
	<?php
$show_variation_image = ! empty( BricksUltimate\Plugin::$bu_settings['sw_variation_images'] ) ? BricksUltimate\Plugin::$bu_settings['sw_variation_images'] : 'disabled';

if ( is_array( $options ) ) {
	if ( isset( $_REQUEST[ 'attribute_' . $attribute_name ] ) ) {
		$selected_value = $_REQUEST[ 'attribute_' . $attribute_name ];
	} elseif ( isset( $selected_attributes[ $attribute_name ] ) ) {
		$selected_value = $selected_attributes[ $attribute_name ];
	} else {
		$selected_value = '';
	}

	$data = '';
	if( ! empty( $settings['enableSync'] ) ) {
		$btnElement = \BricksUltimate\Helpers::get_value( $settings, 'buttonElement', 'atc' );
		$data .= 'data-atc-type="' . $btnElement . '" ';

		if( ! empty( $btnElement ) && 'atc' == $btnElement ) {
			$data .= 'data-variable-btn-text="' . \BricksUltimate\Helpers::get_value( $settings, 'variableButtonText', false ) . '" ';
		}
	}

	if ( taxonomy_exists( $attribute_name ) ) {
		$terms = wc_get_product_terms( $product->get_id(), $attribute_name, array( 'fields' => 'all' ) );
		$options_fliped = array_flip( $options );

		foreach ( $terms as $term ) {
			if ( ! in_array( $term->slug, $options ) ) {
				continue;
			}

			$key = $options_fliped[$term->slug];

			$style = '';
			$class = 'bu-swatch swatch-on-loop ';

			$onlyText = get_term_meta($term->term_id, 'bu_show_swatch_label', true);
			$show_variation_image = ! empty( $onlyText ) ? $onlyText : $show_variation_image;

			$hasBg = false;

			if( ! empty( $swatches[$key]['color'] )) {
				$class .= 'swatch-with-bg swatches-color';
				$style = 'background-color:' .  $swatches[$key]['color'];
				$hasBg = true;
			} else if( isset( $swatches[$key]['image_src'] ) && $show_variation_image == 'enabled' ) {
				$thumb = wp_get_attachment_image_src( get_post_thumbnail_id( $swatches[$key]['variation_id'] ), 'woocommerce_thumbnail');
				if ( !empty( $thumb ) ) {
					$style = 'background-image: url(' . $thumb[0] . ')';
					$class .= 'swatch-with-bg swatches-image';
					$hasBg = true;
				}
			} else if ( ! empty( $swatches[$key]['image'] ) ) {
				$class .= 'swatch-with-bg swatches-image';
				$style = 'background-image: url(' . $swatches[$key]['image'] . ')';
				$hasBg = true;
			}

			if ( $selected_value == $term->slug ) {
				$class .= ' active-swatch';
			}

			if ( 'yes' === get_option( 'woocommerce_hide_out_of_stock_items' ) && $selected_variations ) {
				if ( in_array( $term->slug, $selected_variations ) ) {
					$class .= ' swatch-enabled';
				} else {
					$class .= ' swatch-disabled';
				}
			}

			$variation_id = $swatches[$key]['variation_id'] ?? false;
			if( $variation_id && count( $attributes ) < 2 ) {
				$variation = wc_get_product( $variation_id );
				if( $variation && $variation->get_manage_stock() && empty( $swatches[$key]['is_in_stock'] ) ) {
					$class .= ' swatch-ofs';
				}
			}

			echo '<div class="' . esc_attr( $class ) . '" data-value="' . esc_attr( $term->slug ) . '" data-title="' . esc_attr( $term->name ) . '" ' . $data . selected( sanitize_title( $selected_value ), sanitize_title( $term->slug ), false ) . '>';

			if( $hasBg === true ) {
				echo '<span style="' . esc_attr( $style ) .'">' . apply_filters( 'woocommerce_variation_option_name', $term->name, $term, false, $product ) . '</span><label class="bu-swatch-label">' . apply_filters( 'woocommerce_variation_option_name', $term->name, $term, false, $product ) . '</label>';
			} else {
				$label_text = get_term_meta( $term->term_id, 'bricks_swatch_label_value', true );
				echo '<span class="bu-swatch-atts-label">' . apply_filters( 'woocommerce_variation_option_name', ( $label_text != '' ) ? esc_attr( $label_text ) : $term->name, $term, false, $product ) . '</span>';
			}

			echo '</div>';
		}

	} else {
		foreach ( $options as $option ) {
			$class = 'bu-swatch swatch-on-loop ';
			
			if ( in_array( $option, $selected_attributes ) ) {
				$class .= ' active-swatch';
			}

			echo '<div class="' . esc_attr( $class ) . '" data-value="' . esc_attr( $option ) . '" data-title="' . esc_attr( $option ) . '" ' . $data . selected( sanitize_title( $selected_value ), sanitize_title( $option ), false ) . '><span class="bu-swatch-atts-label">' . esc_html( apply_filters( 'woocommerce_variation_option_name', $option, null, false, $product ) ) . '</span></div>';
		}
	}
}
?>
</div>