<?php
/**
 * Frames ACSS Connector Factory class file.
 *
 * @package Frames_Client\ACSS_Connectors
 */

namespace Frames_Client\ACSS_Connectors;

use Frames_Client\ACSS_Connectors\ACSS_Connector_V4_0_0_Dev_20;
use Frames_Client\ACSS_Connectors\ACSS_Connector_V3;
use Frames_Client\ACSS_Connectors\ACSS_Connector_Base;

/**
 * ACSS Connector Factory class.
 */
class ACSS_Connector_Factory {

	/**
	 * List of versions and the connector class. The order is important.
	 *
	 * @var array
	 */
	private static $connectors = array(
		'4.0.0-dev-20' => ACSS_Connector_V4_0_0_Dev_20::class,
		'3.0' => ACSS_Connector_V3::class,
	);

	/**
	 * Get the right connector based on the version of ACSS that is active.
	 *
	 * @param string $version String with the version that is active.
	 * @param array  $widgets List with the Frames Widgets.
	 * @param array  $default_widgets_states List with default states for Frames Widgets.
	 * @return ACSS_Connector_Base
	 */
	public static function get_connector( string $version, array $widgets, array $default_widgets_states ): ACSS_Connector_Base {
		foreach ( self::$connectors as $minVersion => $connectorClass ) {
			if ( version_compare( $version, $minVersion, '>=' ) ) {
				return new $connectorClass( $widgets, $default_widgets_states );
			}
		}

		return new ACSS_Connector_Legacy( $widgets, $default_widgets_states );
	}
}
