<?php
/**
 * Frames ACSS Connector Legacy class file.
 *
 * @package Frames_Client\ACSS_Connectors
 */

namespace Frames_Client\ACSS_Connectors;

use Frames_Client\ACSS_Connectors\ACSS_Connector_Base;

/**
 * ACSS Connector Legacy class.
 * Used for ACSS below v3.
 */
class ACSS_Connector_Legacy extends ACSS_Connector_Base {
	/**
	 * Add hooks
	 *
	 * @return void
	 */
	public function add_hooks(): void {
		add_filter( 'acss/config/variables.json', array( $this, 'inject_acss_variables' ) );
		add_filter( 'acss/config/ui.json', array( $this, 'inject_acss_ui_elements' ) );
	}

	/**
	 * Inject a toggle variable to enable / disable each widget into the ACSS dashboard.
	 *
	 * @param array $config The config options.
	 * @return array
	 */
	public function inject_acss_variables( $config ): array {
		$var_config = &$config['variables'];
		$options_to_add = $this->widgets;
		$options_to_add[] = array(
			'option' => 'option-frames-own-admin-page',
			'label' => 'Give Frames its own admin page?',
		);
		foreach ( $options_to_add as $widget_name => $widget_options ) {
			$option = $widget_options['option'];
			if ( empty( $var_config[ $option ] ) ) {
				$var_config[ $option ] = array();
			}
			$new_settings = array(
				'type' => 'toggle',
				'valueon' => 'on',
				'valueoff' => 'off',
				'default' => 'off',
			);
			$var_config[ $option ] = array_merge( $var_config[ $option ], $new_settings );
		}
		return $config;
	}

	/**
	 * Inject a UI toggle for each widget into the ACSS dashboard.
	 *
	 * @param array $config The config options.
	 * @return array
	 */
	public function inject_acss_ui_elements( $config ): array {
		$frames_config = &$config['tabs']['frames']['content']['frames-components']['content'];
		foreach ( $this->widgets as $widget_name => $widget_options ) {
			$option = $widget_options['option'];
			if ( empty( $frames_config[ $option ] ) ) {
				$frames_config[ $option ] = array();
			}
			$component_name = ucwords( str_replace( '-', ' ', $widget_name ) );
			$label = $widget_options['label'];
			$new_settings = array(
				'type' => 'variable',
				'title' => $label,
				'tooltip' => "Load the Frames {$component_name} Widget.",
			);
			$frames_config[ $option ] = array_merge( $frames_config[ $option ], $new_settings );
		}
		$frames_additional = &$config['tabs']['frames']['content']['additional-frames-options']['content'];
		$frames_options_page = array(
			'type' => 'variable',
			'title' => 'Give Frames its own admin page?',
			'tooltip' => 'Create a dedicated admin page for Frames.',
		);
		$frames_additional['option-frames-own-admin-page'] = $frames_options_page;
		return $config;
	}
}
