<?php
/**
 * Frames ACSS Connector V3 class file.
 *
 * @package Frames_Client\ACSS_Connectors
 */

namespace Frames_Client\ACSS_Connectors;

use Frames_Client\ACSS_Connectors\ACSS_Connector_Base;

/**
 * ACSS Connector V3 class.
 */
class ACSS_Connector_V3 extends ACSS_Connector_Base {
	/**
	 * Add hooks
	 *
	 * @return void
	 */
	public function add_hooks(): void {
		add_filter( 'acss/config/ui.json/after_load', array( $this, 'inject_acss_settings' ) );
	}

	/**
	 * Inject a toggle variable to enable / disable each widget into the ACSS dashboard.
	 *
	 * @param array $config The config options.
	 * @return array
	 */
	public function inject_acss_settings( array $config ) {
		$acss_settings = $config;
		$acss_settings = $this->inject_components( $acss_settings );
		$acss_settings = $this->inject_options( $acss_settings );

		return $acss_settings;
	}

	/**
	 * Inject Frames Components in the ACSS Dashboard
	 *
	 * @param array $config The config options.
	 * @return array
	 */
	public function &inject_components( array $config ): array {
		$frames_components = &$this->get_acss_settings( $config, 'frames-components' );

		if ( is_array( $frames_components ) ) {
			// STEP: loop through the widgets and add the settings.
			foreach ( $this->widgets as $widget_name => $widget_options ) {
				$option = $widget_options['option'];
				$label = $widget_options['label'];
				$default = $this->default_widgets_states[ $widget_name ] ?? 'off'; // todo Add a test for this widgets default state.
				$new_settings = array(
					'id' => $option,
					'title' => $label,
					'type' => 'toggle',
					'default' => $default,
					'style' => '',
				);
				// STEP: search for an existing setting and merge the new settings over the existing ones.
				$setting_already_exists = false;
				foreach ( $frames_components as $key => $value ) {
					if ( isset( $frames_components[ $key ]['id'] ) && $option === $frames_components[ $key ]['id'] ) {
						$setting_already_exists = true;
						$frames_components[ $key ] = array_merge( $frames_components[ $key ], $new_settings );
						break;
					}
				}
				// STEP: add the new settings if it doesn't exist.
				if ( ! $setting_already_exists ) {
					$frames_components[] = $new_settings;
				}
			}
		}
		return $config;
	}

	/**
	 * Inject Frames Options in the ACSS Dashboard
	 *
	 * @param array $config The config options.
	 * @return array
	 */
	public function &inject_options( array $config ): array {
		$frames_options = &$this->get_acss_settings( $config, 'frames-options' );

		if ( is_array( $frames_options ) ) {
			$frames_options_page = array(
				'id' => 'option-frames-own-admin-page',
				'title' => 'Give Frames its own admin page?',
				'type' => 'toggle',
				'default' => 'off',
			);
			$frames_options[] = $frames_options_page;
		}
		return $config;
	}

	/**
	 * Find the frames-components content for the proper ACSS version
	 *
	 * @param array  $config The config options.
	 * @param string $config_id The config ID to search for.
	 * @return array|null
	 */
	protected function &get_acss_settings( &$config, $config_id ): ?array {
		if ( ! isset( $config['content'] ) ) {
			return null;
		}
		$var_config = &$config['content'];
		// This is the structure we're looking for inside of $var_config:
		// $var_config['id' = 'frames]['content']['id' = 'frames-components']['content'].
		// STEP: find the frames-components content.
		if ( is_array( $var_config ) ) {
			foreach ( $var_config as &$item ) {
				if ( isset( $item['id'] ) && 'frames' === $item['id'] ) {
					$sub_array = &$item['content'] ?? null;
					if ( is_array( $sub_array ) ) {
						foreach ( $sub_array as &$sub_item ) {
							if ( isset( $sub_item['id'] ) && $config_id === $sub_item['id'] ) {
								$frames_content = &$sub_item['content'] ?? null;
								if ( is_array( $frames_content ) ) {
									return $frames_content;
								}
							}
						}
					}
				}
			}
		}
		return null;
	}
}
