<?php
/**
 * Frames ACSS Connector V4.0.0-dev-20 class file.
 *
 * @package Frames_Client\ACSS_Connectors
 */

namespace Frames_Client\ACSS_Connectors;

use Frames_Client\ACSS_Connectors\ACSS_Connector_V3;

/**
 * ACSS Connector V4.0.0-dev-20 class
 */
class ACSS_Connector_V4_0_0_Dev_20 extends ACSS_Connector_V3 {
	/**
	 * Inject Frames Options in the ACSS Dashboard
	 *
	 * @param array $config The config options.
	 * @return array
	 */
	public function &inject_options( array $config ): array {
		$frames_options = &$this->get_acss_settings( $config, 'frames-additional-options' );

		if ( is_array( $frames_options ) ) {
			$frames_options_page = array(
				'id' => 'option-frames-own-admin-page',
				'title' => 'Give Frames its own admin page?',
				'type' => 'toggle',
				'default' => 'off',
			);
			$frames_options[] = $frames_options_page;
		}

		return $config;
	}

	/**
	 * Find the frames-components content for the proper ACSS version
	 *
	 * @param array  $config The config options.
	 * @param string $config_id The config ID to search for.
	 * @return array|null
	 */
	protected function &get_acss_settings( &$config, $config_id ): ?array {
		if ( ! isset( $config['content'] ) ) {
			return null;
		}
		$var_config = &$config['content'];
		// This is the structure we're looking for inside of $var_config:
		// $var_config['id' = 'frames]['content']['id' = 'frames-components']['content'].
		// STEP: find the frames-components content.
		if ( is_array( $var_config ) ) {
			foreach ( $var_config as &$master_item ) {
				if ( isset( $master_item['id'] ) && 'options' === $master_item['id'] ) {
					foreach ( $master_item['content'] as &$item ) {
						if ( isset( $item['id'] ) && 'frames-options' === $item['id'] ) {
							$sub_array = &$item['content'] ?? null;
							if ( is_array( $sub_array ) ) {
								foreach ( $sub_array as &$sub_item ) {
									if ( isset( $sub_item['id'] ) && $config_id === $sub_item['id'] ) {
										$frames_content = &$sub_item['content'] ?? null;
										if ( is_array( $frames_content ) ) {
											return $frames_content;
										}
									}
								}
							}
						}
					}
				}
			}
		}
		return null;
	}
}
