<?php
/**
 * Frames ACSS Helper.
 *
 * @package Frames_Client
 */

namespace Frames_Client\Helpers;

use Frames_Client\Helpers\Logger;
/**
 * Frames ACSS Helper class.
 */
class ACSS {
	/**
	 * Check if the ACSS plugin is ready to be used (plugin is active and Database Settings are accessible)
	 *
	 * @return bool
	 */
	public static function is_ready(): bool {
		if ( ! is_plugin_active( 'automaticcss-plugin/automaticcss-plugin.php' ) ) {
			Logger::log( sprintf( '%s: Automatic CSS is not activated', __METHOD__ ) );
			return false;
		}
		if ( ! class_exists( \Automatic_CSS\Model\Database_Settings::class ) || ! method_exists( \Automatic_CSS\Model\Database_Settings::class, 'get_instance' ) ) {
			Logger::log( sprintf( '%s: Automatic CSS Database Settings class is not accessible', __METHOD__ ) );
			return false;
		}

		return true;
	}

	/**
	 * Get the ACSS plugin version if activated or empty string if not
	 *
	 * @return false|string
	 */
	public static function get_version() {
		if ( ! self::is_ready() ) {
			return false;
		}
		if ( ! class_exists( \Automatic_CSS\Plugin::class ) || ! method_exists( \Automatic_CSS\Plugin::class, 'get_plugin_version' ) ) {
			Logger::log( sprintf( '%s: Automatic CSS Plugin class is not accessible to get the plugin version', __METHOD__ ) );
			return false;
		}

		$acss_version = \Automatic_CSS\Plugin::get_plugin_version();

		return is_string( $acss_version ) ? $acss_version : false;
	}

	/**
	 * Get the ACSS settings object
	 *
	 * @return false|Object
	 */
	public static function get_settings() {
		if ( ! self::is_ready() ) {
			return false;
		}

		return \Automatic_CSS\Model\Database_Settings::get_instance();
	}
}
