"use strict";function parseTocOptions(t){var e=t.dataset.frTocOptions;if(!e)throw new Error("Table of Contents options are required but none were provided");try{return JSON.parse(e)}catch(t){throw console.error("Failed to parse ToC options:",t),t}}function haveAdminBar(){return!!document.getElementById("wpadminbar")}function getAdminBarHeight(){return haveAdminBar()?document.getElementById("wpadminbar").offsetHeight:0}function findEditorCanvas(){var t=document.querySelector(".bricks-area");if(t)return t;console.error("Editor Canvas not found")}function findTocComponents(t){var e=t.querySelectorAll(".fr-toc-component");if(e&&0!==e.length)return e;console.warn("No ToC components found in editor canvas")}function findTocElement(t){return t.querySelector(".fr-toc")}function observeEditorCanvas(t){if(t){var e=new MutationObserver((function(t){t.flatMap((function(t){return Array.from(t.addedNodes)})).filter((function(t){var e;return null===(e=t.matches)||void 0===e?void 0:e.call(t,".fr-toc-component")})).forEach(initializeTocComponent)}));return e.observe(t,{childList:!0,subtree:!0}),e}}function destroyTocInstance(t){var e;null!==(e=t.currentTocInstance)&&void 0!==e&&e.destroy&&t.currentTocInstance.destroy(),t.currentTocInstance=null}function getContentHeadings(t){var e=document.querySelector(t);return!!e&&e.querySelectorAll("h2, h3, h4, h5, h6").length>0}function observeContentSelector(t,e,n){if(getContentHeadings(t))return e(),null;var o=new MutationObserver((function(){getContentHeadings(t)&&(o.disconnect(),e())}));return o.observe(n,{childList:!0,subtree:!0}),o}function newTocInstance(t,e,n){return getContentHeadings(e.frTocContentSelector)?(destroyTocInstance(n),new window.Frames.TableOfContents(t,e)):null}function buildToc(t,e,n){n.contentObserver&&n.contentObserver.disconnect();var o=newTocInstance(t,e,n);if(o)n.currentTocInstance=o;else{var r=findEditorCanvas();r?n.contentObserver=observeContentSelector(e.frTocContentSelector,(function(){destroyTocInstance(n);var o=newTocInstance(t,e,n);n.currentTocInstance=o}),r):console.error("Editor Canvas not found")}}function rebuildToc(t,e){var n,o=parseTocOptions(t);null!=o&&null!==(n=o.frTocContentSelector)&&void 0!==n&&n.trim()&&"."!==o.frTocContentSelector?setTimeout((function(){return buildToc(t,o,e)}),300):destroyTocInstance(e)}var timeoutId=null,throttleDelay=200;function handleTocMutations(t,e,n){return timeoutId&&clearTimeout(timeoutId),timeoutId=setTimeout((function(){var o=findTocElement(e),r=t.some((function(t){return"attributes"===t.type&&"data-fr-toc-options"===t.attributeName}));o?n.currentTocInstance&&!r||rebuildToc(o,n):n.currentTocInstance&&destroyTocInstance(n),timeoutId=null}),throttleDelay),function(){timeoutId&&(clearTimeout(timeoutId),timeoutId=null)}}function observeTocComponent(t){var e={currentTocInstance:null,contentObserver:null},n=new MutationObserver((function(n){var o=handleTocMutations(n,t,e);if(o)return o}));n.observe(t,{childList:!0,subtree:!0,attributes:!0,attributeFilter:["data-fr-toc-options"]});var o=findTocElement(t);return o&&rebuildToc(o,e),function(){n.disconnect(),e.contentObserver&&e.contentObserver.disconnect(),destroyTocInstance(e)}}function initializeTocComponent(t){observeTocComponent(t)}function initEditor(){console.log("Initializing ToC in editor");var t=findEditorCanvas();if(t){observeEditorCanvas(t);var e=findTocComponents(t);e&&e.forEach(initializeTocComponent)}else console.error("Editor Canvas not found")}function _typeof(t){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},_typeof(t)}function _classCallCheck(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}function _defineProperties(t,e){for(var n=0;n<e.length;n++){var o=e[n];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(t,_toPropertyKey(o.key),o)}}function _createClass(t,e,n){return e&&_defineProperties(t.prototype,e),n&&_defineProperties(t,n),Object.defineProperty(t,"prototype",{writable:!1}),t}function _toPropertyKey(t){var e=_toPrimitive(t,"string");return"symbol"==_typeof(e)?e:e+""}function _toPrimitive(t,e){if("object"!=_typeof(t)||!t)return t;var n=t[Symbol.toPrimitive];if(void 0!==n){var o=n.call(t,e||"default");if("object"!=_typeof(o))return o;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===e?String:Number)(t)}var TableOfContents=function(){return _createClass((function t(e,n){_classCallCheck(this,t),this.initProperties(e,n),this.prepareDOM(),this.setupTableOfContents()}),[{key:"initProperties",value:function(t,e){this.tocElement=t,this.tocOptions=e,this.frTocContentSelector=e.frTocContentSelector,this.frTocShowHeadingsUpTo=e.frTocHeading,this.frToCScrollOffset=parseInt(e.frTocScrollOffset,10)||0,this.frTocHeaderSelector=e.frTocHeaderSelector,this.frTocUseBottomOffset=e.frTocUseBottomOffset||!1}},{key:"prepareDOM",value:function(){var t;if(this.frTableOfContentList=this.tocElement.querySelector(".fr-toc__list"),null!==(t=this.frTableOfContentList)&&void 0!==t&&t.firstElementChild&&this.frTableOfContentList.removeChild(this.frTableOfContentList.firstElementChild),this.frTableOfContentPostContent=document.querySelector(this.frTocContentSelector),!this.frTableOfContentPostContent)throw new Error('Content selector "'.concat(this.frTocContentSelector,'" not found'));this.frTableOfContentHeadings=this.frTableOfContentPostContent.querySelectorAll("h2, h3, h4, h5, h6")}},{key:"setupTableOfContents",value:function(){this.createFramesTableOfContentList(this.frTableOfContentHeadings),this.frTableOfContentLinks=this.tocElement.querySelectorAll(".fr-toc__list-link"),this.toggleActiveClassForFramesTOCLink(this.frToCScrollOffset,this.tocItems),this.smoothScrollForFramesTOC(this.frToCScrollOffset,this.tocItems),"false"!==this.tocOptions.frTocAccordion&&this.accordionForFramesTOC(),this.outputListType(this.tocElement),this.outputSublistType(this.tocElement),this.useBottomOffset()}},{key:"haveAdminBar",value:function(){return!!document.body.classList.contains("admin-bar")}},{key:"outputListType",value:function(t){var e=this.tocOptions.frTocListType;t.setAttribute("data-fr-toc-list-type",e)}},{key:"outputSublistType",value:function(t){var e=this.tocOptions.frTocSubListType;t.setAttribute("data-fr-toc-sublist-type",e)}},{key:"headingIdGeneration",value:function(t,e){if(!t.id){var n=t.textContent.split(" ").slice(0,3).join("-").toLowerCase();return"".concat(n,"-").concat(e)}return t.id}},{key:"useBottomOffset",value:function(){var t=document.querySelector(this.frTocContentSelector);if("false"!==this.frTocUseBottomOffset){var e=this.getLastHeading(t),n=this.getLastChild(t),o=window.innerHeight,r=this.getHeaderHeight().headerHeight,i=document.documentElement.scrollHeight,s=e.offset+e.offsetHeight+e.marginBottom+e.marginTop,c=o-r-this.frToCScrollOffset-(i-s);c>0&&(n.element.style.marginBottom="".concat(c,"px"))}else{var a=this.getLastChild(t);a.element&&(a.element.style.marginBottom="")}}},{key:"getLastHeading",value:function(t){var e=t.querySelectorAll("h2, h3, h4, h5, h6");if(0===e.length)return null;var n=e[e.length-1],o=window.getComputedStyle(n);return{offsetHeight:n.offsetHeight,offset:n.getBoundingClientRect().top+window.scrollY,marginBottom:parseInt(o.marginBottom,10),marginTop:parseInt(o.marginTop,10)}}},{key:"getLastChild",value:function(t){return{element:t.lastElementChild}}},{key:"smoothScrollForFramesTOC",value:function(t,e){var n=t+(this.haveAdminBar()?32:0),o=this.getHeaderHeight().headerHeight;e.forEach((function(t){var e=t.link,r=t.heading,i=window.matchMedia("(prefers-reduced-motion: reduce)").matches;e.addEventListener("click",(function(t){t.preventDefault();var e=r.getBoundingClientRect().top+window.scrollY-n-o+1;window.scrollTo({top:e,behavior:i?"auto":"smooth"})}))}))}},{key:"toggleActiveClassForFramesTOCLink",value:function(t,e){var n=t,o=this.getHeaderHeight(),r=o.headerHeight,i=o.usesHeader,s=e.map((function(t){return t.heading})),c=e.map((function(t){return t.link})),a=function(){for(var t=window.scrollY+n+r,e=-1,o=0;o<s.length&&t>=(i?s[o].offsetTop:s[o].getBoundingClientRect().top+window.scrollY-n);o++)e=o;c.forEach((function(t){return t.classList.remove("fr-toc__list-link--active")})),-1!==e&&c[e].classList.add("fr-toc__list-link--active")};window.addEventListener("scroll",a),a()}},{key:"getHeaderHeight",value:function(){var t=this.frTocHeaderSelector?this.frTocHeaderSelector.trim():null;!t||t.startsWith("#")||t.startsWith(".")||console.error("Provided Selector: ".concat(t," is not valid, must start with '#' or '.'"));var e=t?document.querySelector(t):null,n=100,o=!1;return e?(n=e.offsetHeight,o=!0):t&&console.error("Selector not found: ".concat(t)),{headerHeight:n,usesHeader:o}}},{key:"accordionForFramesTOC",value:function(){var t=this,e=this.tocElement.querySelector(".fr-toc__header"),n=(this.tocElement.querySelectorAll(".fr-toc__body"),"fr-toc__body--open"),o=e.nextElementSibling;"true"===e.getAttribute("aria-expanded")?o.style.maxHeight=o.scrollHeight+"px":o.style.maxHeight=0,e.onclick=function(){"true"===e.getAttribute("aria-expanded")?t.closeItem(o,e,n):t.openItem(o,e,n)}}},{key:"closeItem",value:function(t,e,n){e.setAttribute("aria-expanded",!1),t.classList.remove(n),t.style.maxHeight=0}},{key:"openItem",value:function(t,e,n){e.setAttribute("aria-expanded",!0),t.classList.add(n),t.style.maxHeight=t.scrollHeight+"px"}},{key:"createFramesTableOfContentList",value:function(t){var e=this,n=parseInt(this.frTocShowHeadingsUpTo.substring(1),10);this.frTableOfContentList.innerHTML="";var o=document.createDocumentFragment(),r=[{list:o,level:1}],i=[];t.forEach((function(t,o){var s=parseInt(t.tagName.substring(1),10);if(s<=n){var c=e.headingIdGeneration(t,o);for(t.id=c;s>r[0].level+1;){var a=document.createElement("ol");a.classList.add("fr-toc__list"),r[0].list.lastElementChild?r[0].list.lastElementChild.appendChild(a):r[0].list.appendChild(a),r.unshift({list:a,level:r[0].level+1})}for(;s<=r[0].level&&r.length>1;)r.shift();var l=document.createElement("li");l.classList.add("fr-toc__list-item");var u=document.createElement("a");u.setAttribute("href","#".concat(t.id)),u.classList.add("fr-toc__list-link"),u.textContent=t.textContent,i.push({link:u,heading:t}),l.appendChild(u),r[0].list.appendChild(l)}})),this.frTableOfContentList.appendChild(o),this.tocItems=i}}])}();const table_of_contents=null;function initializeFrontendToC(t){var e=parseTocOptions(t);new window.Frames.TableOfContents(t,e)}function framesTableOfContentsScript(){if(window.Frames=window.Frames||{},window.Frames.TableOfContents=TableOfContents,console.log("New ToC Version"),bricksIsFrontend){var t=document.querySelector(".fr-toc");if(!t)return void console.error("Table of Contents element not found");initializeFrontendToC(t)}}document.addEventListener("DOMContentLoaded",(function(){framesTableOfContentsScript(),bricksIsFrontend||(console.log("Editor Only Functions loaded"),setTimeout((function(){initEditor(),framesTableOfContentsScript()}),500))}));