<?php
/**
 * Marker dynamic data
 *
 * @package   WP Grid Builder - Map Facet
 * @author    Loïc Blascos
 * @copyright 2019-2025 Loïc Blascos
 */

namespace WP_Grid_Builder_Map_Facet\Includes;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Handle dynamic data
 *
 * @class WP_Grid_Builder_Map_Facet\Includes\Dynamic_Data
 * @since 2.0.0
 */
final class Dynamic_Data {

	use Data;

	/**
	 * Constructor
	 *
	 * @since 2.0.0
	 * @access public
	 */
	public function __construct() {

		add_filter( 'wp_grid_builder/dynamic_tags', [ $this, 'tags_context' ] );
		add_filter( 'wp_grid_builder/dynamic_tag/render', [ $this, 'post_tags' ], 0, 4 );
		add_filter( 'wp_grid_builder/dynamic_tag/render', [ $this, 'term_tags' ], 0, 4 );
		add_filter( 'wp_grid_builder/dynamic_tag/render', [ $this, 'user_tags' ], 0, 4 );

	}

	/**
	 * Add map context for dynamic data
	 *
	 * @since 2.0.0
	 * @access public
	 *
	 * @param array $tags Holds dynamic tags.
	 * @return array
	 */
	public function tags_context( $tags ) {

		$allowed = [ 'post', 'term', 'user', 'current_user', 'date' ];

		foreach ( $tags as $group => &$tag ) {

			if ( in_array( $group, $allowed, true ) ) {

				$tag['options'] = array_map(
					function( $option ) {

						$option['context'][] = 'map';
						return $option;

					},
					$tag['options']
				);
			}
		}

		return $tags;

	}

	/**
	 * Post tags
	 *
	 * @since 2.0.0
	 * @access public
	 *
	 * @param string $return    Returned value.
	 * @param string $key       key condition.
	 * @param array  $args      Tag arguments.
	 * @param string $context   Condition context.
	 * @return mixed
	 */
	public function post_tags( $return, $key, $args, $context ) {

		global $wpgb_marker_id;

		if ( 'marker' !== $context ) {
			return $return;
		}

		return $this->post_data( $return, $key, $wpgb_marker_id, $args );

	}

	/**
	 * Term tags
	 *
	 * @since 2.0.0
	 * @access public
	 *
	 * @param string $return    Returned value.
	 * @param string $key       key condition.
	 * @param array  $args      Tag arguments.
	 * @param string $context   Condition context.
	 * @return mixed
	 */
	public function term_tags( $return, $key, $args, $context ) {

		global $wpgb_marker_id;

		if ( 'marker' !== $context ) {
			return $return;
		}

		return $this->term_data( $return, $key, $wpgb_marker_id, $args );

	}

	/**
	 * User tags
	 *
	 * @since 2.0.0
	 * @access public
	 *
	 * @param string $return    Returned value.
	 * @param string $key       Key condition.
	 * @param array  $args      Tag arguments.
	 * @param string $context   Condition context.
	 * @return mixed
	 */
	public function user_tags( $return, $key, $args, $context ) {

		global $wpgb_marker_id;

		if ( 'marker' !== $context ) {
			return $return;
		}

		return $this->user_data( $return, $key, $wpgb_marker_id, $args );

	}
}
