<?php
/**
 * Geolocation block
 *
 * @package   WP Grid Builder
 * @author    Loïc Blascos
 * @copyright 2019-2025 Loïc Blascos
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

return [
	'attributes' => [
		'content' => [
			'type'    => 'object',
			'default' => [
				'source'                           => 'map_block',
				'map_block'                        => 'geo_distance',
				'geo_distance_text'                => '[distance]km',
				'geo_distance_unit'                => 'km',
				'geo_distance_decimal_places'      => 0,
				'geo_distance_decimal_separator'   => '.',
				'geo_distance_thousands_separator' => '',
			],
		],
		'style'   => [
			'type'    => 'object',
			'default' => [
				'idle' => [
					'font-size'   => '1em',
					'line-height' => 1,
				],
			],
		],
	],
	'controls'   => [
		'panel' => [
			'type'   => 'panel',
			'fields' => [
				'map_block'                        => [
					'type'   => 'select',
					'hidden' => true,
				],
				'geo_distance_text'                => [
					'type'        => 'text',
					'label'       => __( 'Distance Text', 'wpgb-map-facet' ),
					'placeholder' => '[distance]km',
				],
				'geo_distance_unit'                => [
					'type'    => 'button',
					'label'   => __( 'Distance Unit', 'wpgb-map-facet' ),
					'options' => [
						[
							'value' => 'km',
							'label' => __( 'Kilometer', 'wpgb-map-facet' ),
						],
						[
							'value' => 'mi',
							'label' => __( 'Mile', 'wpgb-map-facet' ),
						],
					],
				],
				'geo_distance_decimal_places'      => [
					'type'  => 'number',
					'label' => __( 'Decimal Places', 'wpgb-map-facet' ),
					'min'   => 0,
					'max'   => 99,
					'step'  => 1,
				],
				'geo_distance_decimal_separator'   => [
					'type'  => 'text',
					'label' => __( 'Decimal Separator', 'wpgb-map-facet' ),
				],
				'geo_distance_thousands_separator' => [
					'type'        => 'text',
					'label'       => __( 'Thousands Separator', 'wpgb-map-facet' ),
					'whiteSpaces' => true,
				],
			],
		],
	],
];
