<?php
/**
 * Geolocation Facet
 *
 * @package   WP Grid Builder
 * @author    Loïc Blascos
 * @copyright 2019-2025 Loïc Blascos
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

return [
	[
		'type'   => 'clone',
		'fields' => [
			'content_type',
			'source',
			'parent',
			'include',
			'exclude',
		],
	],
	[
		'type'   => 'fieldset',
		'legend' => __( 'Geolocation', 'wpgb-map-facet' ),
		'fields' => [
			'geo_type'         => [
				'type'    => 'button',
				'label'   => __( 'Geocoding API', 'wpgb-map-facet' ),
				'options' => [
					[
						'value' => 'mapbox',
						'label' => 'Mapbox',
					],
					[
						'value' => 'google',
						'label' => 'Google',
					],
				],
			],
			'map_access_token' => [
				'type'         => 'password',
				'label'        => __( 'Access Token', 'wpgb-map-facet' ),
				'autoComplete' => 'new-password',
				'condition'    => [
					[
						'field'   => 'geo_type',
						'compare' => '===',
						'value'   => 'mapbox',
					],
				],
			],
			'map_api_key'      => [
				'type'         => 'password',
				'label'        => __( 'API Key', 'wpgb-map-facet' ),
				'autoComplete' => 'new-password',
				'condition'    => [
					[
						'field'   => 'geo_type',
						'compare' => '===',
						'value'   => 'google',
					],
				],
			],
			'geo_countries'    => [
				'type'         => 'select',
				'label'        => __( 'Restrict Search to', 'wpgb-map-facet' ),
				'multiple'     => true,
				'isSearchable' => true,
				'placeholder'  => __( 'All countries', 'wpgb-map-facet' ),
				'info'         => __( 'Google API is limited to 5 countries at maximum.', 'wpgb-map-facet' ),
				'options'      => [
					[
						'value' => 'AF',
						'label' => 'Afghanistan',
					],
					[
						'value' => 'AX',
						'label' => 'Åland Islands',
					],
					[
						'value' => 'AL',
						'label' => 'Albania',
					],
					[
						'value' => 'DZ',
						'label' => 'Algeria',
					],
					[
						'value' => 'AS',
						'label' => 'American Samoa',
					],
					[
						'value' => 'AD',
						'label' => 'Andorra',
					],
					[
						'value' => 'AO',
						'label' => 'Angola',
					],
					[
						'value' => 'AI',
						'label' => 'Anguilla',
					],
					[
						'value' => 'AQ',
						'label' => 'Antarctica',
					],
					[
						'value' => 'AG',
						'label' => 'Antigua and Barbuda',
					],
					[
						'value' => 'AR',
						'label' => 'Argentina',
					],
					[
						'value' => 'AM',
						'label' => 'Armenia',
					],
					[
						'value' => 'AW',
						'label' => 'Aruba',
					],
					[
						'value' => 'AU',
						'label' => 'Australia',
					],
					[
						'value' => 'AT',
						'label' => 'Austria',
					],
					[
						'value' => 'AZ',
						'label' => 'Azerbaijan',
					],
					[
						'value' => 'BS',
						'label' => 'Bahamas',
					],
					[
						'value' => 'BH',
						'label' => 'Bahrain',
					],
					[
						'value' => 'BD',
						'label' => 'Bangladesh',
					],
					[
						'value' => 'BB',
						'label' => 'Barbados',
					],
					[
						'value' => 'BY',
						'label' => 'Belarus',
					],
					[
						'value' => 'BE',
						'label' => 'Belgium',
					],
					[
						'value' => 'PW',
						'label' => 'Belau',
					],
					[
						'value' => 'BZ',
						'label' => 'Belize',
					],
					[
						'value' => 'BJ',
						'label' => 'Benin',
					],
					[
						'value' => 'BM',
						'label' => 'Bermuda',
					],
					[
						'value' => 'BT',
						'label' => 'Bhutan',
					],
					[
						'value' => 'BO',
						'label' => 'Bolivia',
					],
					[
						'value' => 'BQ',
						'label' => 'Bonaire, Saint Eustatius and Saba',
					],
					[
						'value' => 'BA',
						'label' => 'Bosnia and Herzegovina',
					],
					[
						'value' => 'BW',
						'label' => 'Botswana',
					],
					[
						'value' => 'BV',
						'label' => 'Bouvet Island',
					],
					[
						'value' => 'BR',
						'label' => 'Brazil',
					],
					[
						'value' => 'IO',
						'label' => 'British Indian Ocean Territory',
					],
					[
						'value' => 'BN',
						'label' => 'Brunei',
					],
					[
						'value' => 'BG',
						'label' => 'Bulgaria',
					],
					[
						'value' => 'BF',
						'label' => 'Burkina Faso',
					],
					[
						'value' => 'BI',
						'label' => 'Burundi',
					],
					[
						'value' => 'KH',
						'label' => 'Cambodia',
					],
					[
						'value' => 'CM',
						'label' => 'Cameroon',
					],
					[
						'value' => 'CA',
						'label' => 'Canada',
					],
					[
						'value' => 'CV',
						'label' => 'Cape Verde',
					],
					[
						'value' => 'KY',
						'label' => 'Cayman Islands',
					],
					[
						'value' => 'CF',
						'label' => 'Central African Republic',
					],
					[
						'value' => 'TD',
						'label' => 'Chad',
					],
					[
						'value' => 'CL',
						'label' => 'Chile',
					],
					[
						'value' => 'CN',
						'label' => 'China',
					],
					[
						'value' => 'CX',
						'label' => 'Christmas Island',
					],
					[
						'value' => 'CC',
						'label' => 'Cocos (Keeling) Islands',
					],
					[
						'value' => 'CO',
						'label' => 'Colombia',
					],
					[
						'value' => 'KM',
						'label' => 'Comoros',
					],
					[
						'value' => 'CG',
						'label' => 'Congo (Brazzaville)',
					],
					[
						'value' => 'CD',
						'label' => 'Congo (Kinshasa)',
					],
					[
						'value' => 'CK',
						'label' => 'Cook Islands',
					],
					[
						'value' => 'CR',
						'label' => 'Costa Rica',
					],
					[
						'value' => 'HR',
						'label' => 'Croatia',
					],
					[
						'value' => 'CU',
						'label' => 'Cuba',
					],
					[
						'value' => 'CW',
						'label' => 'Curaçao',
					],
					[
						'value' => 'CY',
						'label' => 'Cyprus',
					],
					[
						'value' => 'CZ',
						'label' => 'Czech Republic',
					],
					[
						'value' => 'DK',
						'label' => 'Denmark',
					],
					[
						'value' => 'DJ',
						'label' => 'Djibouti',
					],
					[
						'value' => 'DM',
						'label' => 'Dominica',
					],
					[
						'value' => 'DO',
						'label' => 'Dominican Republic',
					],
					[
						'value' => 'EC',
						'label' => 'Ecuador',
					],
					[
						'value' => 'EG',
						'label' => 'Egypt',
					],
					[
						'value' => 'SV',
						'label' => 'El Salvador',
					],
					[
						'value' => 'GQ',
						'label' => 'Equatorial Guinea',
					],
					[
						'value' => 'ER',
						'label' => 'Eritrea',
					],
					[
						'value' => 'EE',
						'label' => 'Estonia',
					],
					[
						'value' => 'ET',
						'label' => 'Ethiopia',
					],
					[
						'value' => 'FK',
						'label' => 'Falkland Islands',
					],
					[
						'value' => 'FO',
						'label' => 'Faroe Islands',
					],
					[
						'value' => 'FJ',
						'label' => 'Fiji',
					],
					[
						'value' => 'FI',
						'label' => 'Finland',
					],
					[
						'value' => 'FR',
						'label' => 'France',
					],
					[
						'value' => 'GF',
						'label' => 'French Guiana',
					],
					[
						'value' => 'PF',
						'label' => 'French Polynesia',
					],
					[
						'value' => 'TF',
						'label' => 'French Southern Territories',
					],
					[
						'value' => 'GA',
						'label' => 'Gabon',
					],
					[
						'value' => 'GM',
						'label' => 'Gambia',
					],
					[
						'value' => 'GE',
						'label' => 'Georgia',
					],
					[
						'value' => 'DE',
						'label' => 'Germany',
					],
					[
						'value' => 'GH',
						'label' => 'Ghana',
					],
					[
						'value' => 'GI',
						'label' => 'Gibraltar',
					],
					[
						'value' => 'GR',
						'label' => 'Greece',
					],
					[
						'value' => 'GL',
						'label' => 'Greenland',
					],
					[
						'value' => 'GD',
						'label' => 'Grenada',
					],
					[
						'value' => 'GP',
						'label' => 'Guadeloupe',
					],
					[
						'value' => 'GU',
						'label' => 'Guam',
					],
					[
						'value' => 'GT',
						'label' => 'Guatemala',
					],
					[
						'value' => 'GG',
						'label' => 'Guernsey',
					],
					[
						'value' => 'GN',
						'label' => 'Guinea',
					],
					[
						'value' => 'GW',
						'label' => 'Guinea-Bissau',
					],
					[
						'value' => 'GY',
						'label' => 'Guyana',
					],
					[
						'value' => 'HT',
						'label' => 'Haiti',
					],
					[
						'value' => 'HM',
						'label' => 'Heard Island and McDonald Islands',
					],
					[
						'value' => 'HN',
						'label' => 'Honduras',
					],
					[
						'value' => 'HK',
						'label' => 'Hong Kong',
					],
					[
						'value' => 'HU',
						'label' => 'Hungary',
					],
					[
						'value' => 'IS',
						'label' => 'Iceland',
					],
					[
						'value' => 'IN',
						'label' => 'India',
					],
					[
						'value' => 'ID',
						'label' => 'Indonesia',
					],
					[
						'value' => 'IR',
						'label' => 'Iran',
					],
					[
						'value' => 'IQ',
						'label' => 'Iraq',
					],
					[
						'value' => 'IE',
						'label' => 'Ireland',
					],
					[
						'value' => 'IM',
						'label' => 'Isle of Man',
					],
					[
						'value' => 'IL',
						'label' => 'Israel',
					],
					[
						'value' => 'IT',
						'label' => 'Italy',
					],
					[
						'value' => 'CI',
						'label' => 'Ivory Coast',
					],
					[
						'value' => 'JM',
						'label' => 'Jamaica',
					],
					[
						'value' => 'JP',
						'label' => 'Japan',
					],
					[
						'value' => 'JE',
						'label' => 'Jersey',
					],
					[
						'value' => 'JO',
						'label' => 'Jordan',
					],
					[
						'value' => 'KZ',
						'label' => 'Kazakhstan',
					],
					[
						'value' => 'KE',
						'label' => 'Kenya',
					],
					[
						'value' => 'KI',
						'label' => 'Kiribati',
					],
					[
						'value' => 'KW',
						'label' => 'Kuwait',
					],
					[
						'value' => 'KG',
						'label' => 'Kyrgyzstan',
					],
					[
						'value' => 'LA',
						'label' => 'Laos',
					],
					[
						'value' => 'LV',
						'label' => 'Latvia',
					],
					[
						'value' => 'LB',
						'label' => 'Lebanon',
					],
					[
						'value' => 'LS',
						'label' => 'Lesotho',
					],
					[
						'value' => 'LS',
						'label' => 'Lesotho',
					],
					[
						'value' => 'LR',
						'label' => 'Liberia',
					],
					[
						'value' => 'LY',
						'label' => 'Libya',
					],
					[
						'value' => 'LI',
						'label' => 'Liechtenstein',
					],
					[
						'value' => 'LT',
						'label' => 'Lithuania',
					],
					[
						'value' => 'LU',
						'label' => 'Luxembourg',
					],
					[
						'value' => 'MO',
						'label' => 'Macao',
					],
					[
						'value' => 'MK',
						'label' => 'North Macedonia',
					],
					[
						'value' => 'MG',
						'label' => 'Madagascar',
					],
					[
						'value' => 'MW',
						'label' => 'Malawi',
					],
					[
						'value' => 'MY',
						'label' => 'Malaysia',
					],
					[
						'value' => 'MV',
						'label' => 'Maldives',
					],
					[
						'value' => 'ML',
						'label' => 'Mali',
					],
					[
						'value' => 'MT',
						'label' => 'Malta',
					],
					[
						'value' => 'MH',
						'label' => 'Marshall Islands',
					],
					[
						'value' => 'MQ',
						'label' => 'Martinique',
					],
					[
						'value' => 'MR',
						'label' => 'Mauritania',
					],
					[
						'value' => 'MU',
						'label' => 'Mauritius',
					],
					[
						'value' => 'YT',
						'label' => 'Mayotte',
					],
					[
						'value' => 'MX',
						'label' => 'Mexico',
					],
					[
						'value' => 'FM',
						'label' => 'Micronesia',
					],
					[
						'value' => 'MD',
						'label' => 'Moldova',
					],
					[
						'value' => 'MC',
						'label' => 'Monaco',
					],
					[
						'value' => 'MN',
						'label' => 'Mongolia',
					],
					[
						'value' => 'ME',
						'label' => 'Montenegro',
					],
					[
						'value' => 'MS',
						'label' => 'Montserrat',
					],
					[
						'value' => 'MA',
						'label' => 'Morocco',
					],
					[
						'value' => 'MZ',
						'label' => 'Mozambique',
					],
					[
						'value' => 'MM',
						'label' => 'Myanmar',
					],
					[
						'value' => 'NA',
						'label' => 'Namibia',
					],
					[
						'value' => 'NR',
						'label' => 'Nauru',
					],
					[
						'value' => 'NP',
						'label' => 'Nepal',
					],
					[
						'value' => 'NL',
						'label' => 'Netherlands',
					],
					[
						'value' => 'NC',
						'label' => 'New Caledonia',
					],
					[
						'value' => 'NZ',
						'label' => 'New Zealand',
					],
					[
						'value' => 'NI',
						'label' => 'Nicaragua',
					],
					[
						'value' => 'NE',
						'label' => 'Niger',
					],
					[
						'value' => 'NG',
						'label' => 'Nigeria',
					],
					[
						'value' => 'NU',
						'label' => 'Niue',
					],
					[
						'value' => 'NF',
						'label' => 'Norfolk Island',
					],
					[
						'value' => 'MP',
						'label' => 'Northern Mariana Islands',
					],
					[
						'value' => 'KP',
						'label' => 'North Korea',
					],
					[
						'value' => 'NO',
						'label' => 'Norway',
					],
					[
						'value' => 'OM',
						'label' => 'Oman',
					],
					[
						'value' => 'PK',
						'label' => 'Pakistan',
					],
					[
						'value' => 'PS',
						'label' => 'Palestinian Territory',
					],
					[
						'value' => 'PA',
						'label' => 'Panama',
					],
					[
						'value' => 'PG',
						'label' => 'Papua New Guinea',
					],
					[
						'value' => 'PY',
						'label' => 'Paraguay',
					],
					[
						'value' => 'PE',
						'label' => 'Peru',
					],
					[
						'value' => 'PH',
						'label' => 'Philippines',
					],
					[
						'value' => 'PN',
						'label' => 'Pitcairn',
					],
					[
						'value' => 'PL',
						'label' => 'Poland',
					],
					[
						'value' => 'PT',
						'label' => 'Portugal',
					],
					[
						'value' => 'PR',
						'label' => 'Puerto Rico',
					],
					[
						'value' => 'QA',
						'label' => 'Qatar',
					],
					[
						'value' => 'RE',
						'label' => 'Reunion',
					],
					[
						'value' => 'RO',
						'label' => 'Romania',
					],
					[
						'value' => 'RU',
						'label' => 'Russia',
					],
					[
						'value' => 'RW',
						'label' => 'Rwanda',
					],
					[
						'value' => 'BL',
						'label' => 'Saint Barthélemy',
					],
					[
						'value' => 'SH',
						'label' => 'Saint Helena',
					],
					[
						'value' => 'KN',
						'label' => 'Saint Kitts and Nevis',
					],
					[
						'value' => 'LC',
						'label' => 'Saint Lucia',
					],
					[
						'value' => 'MF',
						'label' => 'Saint Martin (French part)',
					],
					[
						'value' => 'SX',
						'label' => 'Saint Martin (Dutch part)',
					],
					[
						'value' => 'PM',
						'label' => 'Saint Pierre and Miquelon',
					],
					[
						'value' => 'VC',
						'label' => 'Saint Vincent and the Grenadines',
					],
					[
						'value' => 'SM',
						'label' => 'San Marino',
					],
					[
						'value' => 'ST',
						'label' => 'Sao Tome and Principe',
					],
					[
						'value' => 'SA',
						'label' => 'Saudi Arabia',
					],
					[
						'value' => 'SN',
						'label' => 'Senegal',
					],
					[
						'value' => 'RS',
						'label' => 'Serbia',
					],
					[
						'value' => 'SC',
						'label' => 'Seychelles',
					],
					[
						'value' => 'SL',
						'label' => 'Sierra Leone',
					],
					[
						'value' => 'SG',
						'label' => 'Singapore',
					],
					[
						'value' => 'SK',
						'label' => 'Slovakia',
					],
					[
						'value' => 'SI',
						'label' => 'Slovenia',
					],
					[
						'value' => 'SB',
						'label' => 'Solomon Islands',
					],
					[
						'value' => 'SO',
						'label' => 'Somalia',
					],
					[
						'value' => 'ZA',
						'label' => 'South Africa',
					],
					[
						'value' => 'GS',
						'label' => 'South Georgia/Sandwich Islands',
					],
					[
						'value' => 'KR',
						'label' => 'South Korea',
					],
					[
						'value' => 'SS',
						'label' => 'South Sudan',
					],
					[
						'value' => 'ES',
						'label' => 'Spain',
					],
					[
						'value' => 'LK',
						'label' => 'Sri Lanka',
					],
					[
						'value' => 'SD',
						'label' => 'Sudan',
					],
					[
						'value' => 'SR',
						'label' => 'Suriname',
					],
					[
						'value' => 'SJ',
						'label' => 'Svalbard and Jan Mayen',
					],
					[
						'value' => 'SZ',
						'label' => 'Swaziland',
					],
					[
						'value' => 'SE',
						'label' => 'Sweden',
					],
					[
						'value' => 'CH',
						'label' => 'Switzerland',
					],
					[
						'value' => 'SY',
						'label' => 'Syria',
					],
					[
						'value' => 'TW',
						'label' => 'Taiwan',
					],
					[
						'value' => 'TJ',
						'label' => 'Tajikistan',
					],
					[
						'value' => 'TZ',
						'label' => 'Tanzania',
					],
					[
						'value' => 'TH',
						'label' => 'Thailand',
					],
					[
						'value' => 'TL',
						'label' => 'Timor-Leste',
					],
					[
						'value' => 'TG',
						'label' => 'Togo',
					],
					[
						'value' => 'TK',
						'label' => 'Tokelau',
					],
					[
						'value' => 'TO',
						'label' => 'Tonga',
					],
					[
						'value' => 'TT',
						'label' => 'Trinidad and Tobago',
					],
					[
						'value' => 'TN',
						'label' => 'Tunisia',
					],
					[
						'value' => 'TR',
						'label' => 'Turkey',
					],
					[
						'value' => 'TM',
						'label' => 'Turkmenistan',
					],
					[
						'value' => 'TC',
						'label' => 'Turks and Caicos Islands',
					],
					[
						'value' => 'TV',
						'label' => 'Tuvalu',
					],
					[
						'value' => 'UG',
						'label' => 'Uganda',
					],
					[
						'value' => 'UA',
						'label' => 'Ukraine',
					],
					[
						'value' => 'AE',
						'label' => 'United Arab Emirates',
					],
					[
						'value' => 'GB',
						'label' => 'United Kingdom (UK)',
					],
					[
						'value' => 'US',
						'label' => 'United States (US)',
					],
					[
						'value' => 'UM',
						'label' => 'United States (US) Minor Outlying Islands',
					],
					[
						'value' => 'UY',
						'label' => 'Uruguay',
					],
					[
						'value' => 'UZ',
						'label' => 'Uzbekistan',
					],
					[
						'value' => 'VU',
						'label' => 'Vanuatu',
					],
					[
						'value' => 'VA',
						'label' => 'Vatican',
					],
					[
						'value' => 'VE',
						'label' => 'Venezuela',
					],
					[
						'value' => 'VN',
						'label' => 'Vietnam',
					],
					[
						'value' => 'VG',
						'label' => 'Virgin Islands (British)',
					],
					[
						'value' => 'VI',
						'label' => 'Virgin Islands (US)',
					],
					[
						'value' => 'WF',
						'label' => 'Wallis and Futuna',
					],
					[
						'value' => 'EH',
						'label' => 'Western Sahara',
					],
					[
						'value' => 'WS',
						'label' => 'Samoa',
					],
					[
						'value' => 'YE',
						'label' => 'Yemen',
					],
					[
						'value' => 'ZM',
						'label' => 'Zambia',
					],
					[
						'value' => 'ZW',
						'label' => 'Zimbabwe',
					],
				],
			],
			'geo_google_types' => [
				'type'         => 'select',
				'label'        => __( 'Places to Search', 'wpgb-map-facet' ),
				'multiple'     => true,
				'isSearchable' => true,
				'info'         => __( 'Selected place types may appear as a top-level suggestions while searching.', 'wpgb-map-facet' ),
				'placeholder'  => __( 'All types', 'wpgb-map-facet' ),
				'options'      => [
					[
						'value' => 'geocode',
						'label' => __( 'Geocode', 'wpgb-map-facet' ),
					],
					[
						'value' => 'address',
						'label' => __( 'Address', 'wpgb-map-facet' ),
					],
					[
						'value' => 'establishment',
						'label' => __( 'Establishment', 'wpgb-map-facet' ),
					],
					[
						'value' => '(regions)',
						'label' => __( 'Regions', 'wpgb-map-facet' ),
					],
					[
						'value' => '(cities)',
						'label' => __( 'Cities', 'wpgb-map-facet' ),
					],
				],
				'condition'    => [
					[
						'field'   => 'geo_type',
						'compare' => '===',
						'value'   => 'google',
					],
				],
			],
			'geo_mapbox_types' => [
				'type'         => 'select',
				'label'        => __( 'Places to Search', 'wpgb-map-facet' ),
				'multiple'     => true,
				'isSearchable' => true,
				'info'         => __( 'Selected place types may appear as a top-level suggestions while searching.', 'wpgb-map-facet' ),
				'placeholder'  => __( 'All types', 'wpgb-map-facet' ),
				'options'      => [
					[
						'value' => 'country',
						'label' => __( 'Country', 'wpgb-map-facet' ),
					],
					[
						'value' => 'region',
						'label' => __( 'Region', 'wpgb-map-facet' ),
					],
					[
						'value' => 'postcode',
						'label' => __( 'Postal Code', 'wpgb-map-facet' ),
					],
					[
						'value' => 'district',
						'label' => __( 'District', 'wpgb-map-facet' ),
					],
					[
						'value' => 'place',
						'label' => __( 'Place', 'wpgb-map-facet' ),
					],
					[
						'value' => 'locality',
						'label' => __( 'Locality', 'wpgb-map-facet' ),
					],
					[
						'value' => 'neighborhood',
						'label' => __( 'Neighborhood', 'wpgb-map-facet' ),
					],
					[
						'value' => 'address',
						'label' => __( 'Address', 'wpgb-map-facet' ),
					],
					[
						'value' => 'poi',
						'label' => __( 'Points of Interest', 'wpgb-map-facet' ),
					],
				],
				'condition'    => [
					[
						'field'   => 'geo_type',
						'compare' => '===',
						'value'   => 'mapbox',
					],
				],
			],
			'geo_placeholder'  => [
				'type'  => 'text',
				'label' => __( 'Search Placeholder', 'wpgb-map-facet' ),
			],
			'geo_location'     => [
				'type'   => 'popover',
				'label'  => __( 'User\'s Location', 'wpgb-map-facet' ),
				'fields' => [
					'geo_locate_me'       => [
						'type'  => 'toggle',
						'label' => __( 'Locate Me Button', 'wpgb-map-facet' ),
						'help'  => __( 'Display a button in the search field to locate the user.', 'wpgb-map-facet' ),
					],
					'auto_geo_locate'     => [
						'type'      => 'toggle',
						'label'     => __( 'Auto Geolocate', 'wpgb-map-facet' ),
						'help'      => __( 'Retrieves the user\'s position and centers the map on page load.', 'wpgb-map-facet' ),
						'condition' => [
							[
								'field'   => 'geo_locate_me',
								'compare' => '==',
								'value'   => 1,
							],
						],
					],
					'geo_locate_me_label' => [
						'type'      => 'text',
						'label'     => __( 'Button Aria Label', 'wpgb-map-facet' ),
						'help'      => __( 'Message used to provide the label to any assistive technologies.', 'wpgb-map-facet' ),
						'condition' => [
							[
								'field'   => 'geo_locate_me',
								'compare' => '==',
								'value'   => 1,
							],
						],
					],
				],
			],
			'geo_appearance'   => [
				'type'   => 'popover',
				'label'  => __( 'Appearance', 'wpgb-map-facet' ),
				'fields' => [
					'geo_location_circle' => [
						'type'  => 'toggle',
						'label' => __( 'Display Searched Area', 'wpgb-map-facet' ),
						'help'  => __( 'Draw a circle on the map to visualize the searched area.', 'wpgb-map-facet' ),
					],
					'geo_circle_color'    => [
						'type'      => 'color',
						'label'     => __( 'Searched Area Color', 'wpgb-map-facet' ),
						'condition' => [
							[
								'field'   => 'geo_location_circle',
								'compare' => '==',
								'value'   => 1,
							],
						],
					],
				],
			],
		],
	],
	[
		'type'   => 'fieldset',
		'legend' => __( 'Search Radius', 'wpgb-map-facet' ),
		'fields' => [
			'geo_radius_control' => [
				'type'  => 'toggle',
				'label' => __( 'Radius Control', 'wpgb-map-facet' ),
				'help'  => __( 'Display a number field below the search field to adjust the radius.', 'wpgb-map-facet' ),
			],
			'geo_radius_label'   => [
				'type'      => 'text',
				'label'     => __( 'Radius Label', 'wpgb-map-facet' ),
				'condition' => [
					[
						'field'   => 'geo_radius_control',
						'compare' => '==',
						'value'   => 1,
					],
				],
			],
			'grid'               => [
				'type'   => 'grid',
				'fields' => [
					'geo_radius_unit' => [
						'type'    => 'button',
						'label'   => __( 'Radius Unit', 'wpgb-map-facet' ),
						'options' => [
							[
								'value' => 'km',
								'label' => __( 'Kilometer', 'wpgb-map-facet' ),
							],
							[
								'value' => 'mi',
								'label' => __( 'Mile', 'wpgb-map-facet' ),
							],
						],
					],
					'geo_radius'      => [
						'type'      => 'row',
						'className' => 'wpgb-components-row__icon',
						'fields'    => [
							'geo_radius_def' => [
								'type'  => 'number',
								'label' => __( 'Radius', 'wpgb-map-facet' ),
								'icon'  => 'fullscreen',
								'min'   => 0,
								'max'   => 99999,
							],
							'geo_radius_min' => [
								'type'  => 'number',
								'label' => (
									'<span class="wpgb-components-base-control__label-light">' .
										__( 'Min', 'wpgb-map-facet' ) .
									'</span>' .
									'<span class="wpgb-components-visually-hidden">' .
										__( 'Radius', 'wpgb-map-facet' ) .
									'</span>'
								),
								'min'   => 0.001,
								'max'   => 99999,
								'step'  => 0.001,
							],
							'geo_radius_max' => [
								'type'  => 'number',
								'label' => (
									'<span class="wpgb-components-base-control__label-light">' .
										__( 'Max', 'wpgb-map-facet' ) .
									'</span>' .
									'<span class="wpgb-components-visually-hidden">' .
										__( 'Radius', 'wpgb-map-facet' ) .
									'</span>'
								),
								'min'   => 0.001,
								'max'   => 99999,
								'step'  => 0.001,
							],
						],
					],
				],
			],
		],
	],
];
