<?php
/**
 * Map Facet
 *
 * @package   WP Grid Builder
 * @author    Loïc Blascos
 * @copyright 2019-2025 Loïc Blascos
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

return [
	[
		'type'   => 'fieldset',
		'panel'  => 'map_coordinates',
		'legend' => __( 'Coordinates (Map Facet)', 'wpgb-map-facet' ),
		'fields' => [
			'map_lat' => [
				'type'  => 'text',
				'label' => __( 'Latitude', 'wpgb-map-facet' ),
			],
			'map_lng' => [
				'type'  => 'text',
				'label' => __( 'Longitude', 'wpgb-map-facet' ),
			],
		],
	],
];
