<?php
/**
 * Map Facet
 *
 * @package   WP Grid Builder
 * @author    Loïc Blascos
 * @copyright 2019-2025 Loïc Blascos
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

return [
	'locate_button'  => [
		'type'        => 'panel',
		'group'       => 'facet_styles_panels',
		'title'       => __( 'Locate Button', 'wpgb-map-facet' ),
		'clearButton' => true,
		'fields'      => [
			'locate_button'              => [
				'type'      => 'toggle',
				'label'     => __( 'Hide Icon', 'wpgb-map-facet' ),
				'selectors' => [
					'{{wrapper}} .wpgb-locate-button' => [
						'display' => 'none',
					],
				],
			],
			'locate_button_size'         => [
				'type'      => 'range',
				'label'     => __( 'Icon Size', 'wpgb-map-facet' ),
				'min'       => 5,
				'max'       => 50,
				'step'      => 1,
				'suffix'    => 'px',
				'selectors' => [
					'{{wrapper}} .wpgb-locate-button svg' => [
						'transform' => 'scale(calc({{value}}/20))',
					],
				],
				'condition' => [
					[
						'field'   => 'locate_button',
						'compare' => '!=',
						'value'   => 1,
					],
				],
			],
			'locate_button_stroke_width' => [
				'type'      => 'range',
				'label'     => __( 'Stroke Width', 'wpgb-map-facet' ),
				'min'       => 0.1,
				'max'       => 10,
				'step'      => 0.01,
				'selectors' => [
					'{{wrapper}} .wpgb-locate-button svg' => [
						'stroke-width' => '{{value}}',
					],
				],
				'condition' => [
					[
						'field'   => 'locate_button',
						'compare' => '!=',
						'value'   => 1,
					],
				],
			],
			'locate_button_colors'       => [
				'type'      => 'tab-panel',
				'fields'    => [
					[
						'type'   => 'tab',
						'title'  => __( 'Normal', 'wpgb-map-facet' ),
						'name'   => 'normal',
						'fields' => [
							'locate_button_color' => [
								'type'      => 'color',
								'label'     => __( 'Icon Color', 'wpgb-map-facet' ),
								'selectors' => [
									'{{wrapper}} .wpgb-locate-button' => [
										'color' => '{{value}}',
									],
								],
							],
						],
					],
					[
						'type'   => 'tab',
						'title'  => __( 'Hover', 'wpgb-map-facet' ),
						'name'   => 'hover',
						'fields' => [
							'locate_button_color_hover' => [
								'type'      => 'color',
								'label'     => __( 'Icon Color', 'wpgb-map-facet' ),
								'selectors' => [
									'{{wrapper}} .wpgb-locate-button:hover, {{wrapper}} .wpgb-locate-button:focus' => [
										'color' => '{{value}}',
									],
								],
							],
						],
					],
				],
				'condition' => [
					[
						'field'   => 'locate_button',
						'compare' => '!=',
						'value'   => 1,
					],
				],
			],
		],
		'condition'   => [
			[
				'field'   => 'type',
				'compare' => '===',
				'value'   => 'geolocation',
			],
		],
	],
	'radius_control' => [
		'type'        => 'panel',
		'group'       => 'facet_styles_panels',
		'title'       => __( 'Radius Control', 'wpgb-map-facet' ),
		'clearButton' => true,
		'fields'      => [
			'radius_control_alignment'  => [
				'type'      => 'button',
				'label'     => __( 'Alignment', 'wpgb-map-facet' ),
				'options'   => [
					[
						'label' => _x( 'Vertical', 'Layout control value', 'wpgb-map-facet' ),
						'value' => '',
						'icon'  => 'justifyLeft',
					],
					[
						'label' => _x( 'Center', 'Layout control value', 'wpgb-map-facet' ),
						'value' => 'center',
						'icon'  => 'justifyCenter',
					],
					[
						'label' => _x( 'Right', 'Layout control value', 'wpgb-map-facet' ),
						'value' => 'flex-end',
						'icon'  => 'justifyRight',
					],
				],
				'selectors' => [
					'{{wrapper}} .wpgb-geo-radius' => [
						'justify-content' => '{{value}}',
					],
				],
			],
			'radius_control_margin'     => [
				'type'      => 'margin',
				'label'     => _x( 'Margin', 'CSS margin', 'wpgb-map-facet' ),
				'selectors' => [
					'{{wrapper}} .wpgb-geo-radius' => [
						'margin' => '{{value}}',
					],
				],
			],
			'radius_control_padding'    => [
				'type'      => 'padding',
				'label'     => _x( 'Padding', 'CSS Padding', 'wpgb-map-facet' ),
				'selectors' => [
					'{{wrapper}} .wpgb-geo-radius' => [
						'padding' => '{{value}}',
					],
				],
			],
			'radius_control_font'       => [
				'type'   => 'popover',
				'label'  => __( 'Typography', 'wpgb-map-facet' ),
				'fields' => [
					'toggle_button_typography' => [
						'type'      => 'typography',
						'label'     => __( 'Typography', 'wpgb-map-facet' ),
						'selectors' => [
							'{{wrapper}} .wpgb-geo-radius, {{wrapper}} .wpgb-geo-radius input' => [
								'font' => '{{value}}',
							],
						],
					],
				],
			],
			'radius_control_color'      => [
				'type'      => 'color',
				'label'     => __( 'Text Color', 'wpgb-map-facet' ),
				'selectors' => [
					'{{wrapper}} .wpgb-geo-radius, {{wrapper}} .wpgb-geo-radius input' => [
						'color' => '{{value}}',
					],
				],
			],
			'radius_control_background' => [
				'type'      => 'color',
				'label'     => __( 'Background', 'wpgb-map-facet' ),
				'gradient'  => true,
				'selectors' => [
					'{{wrapper}} .wpgb-geo-radius, {{wrapper}} .wpgb-geo-radius input' => [
						'background' => '{{value}}',
					],
				],
			],
		],
		'condition'   => [
			[
				'field'   => 'type',
				'compare' => '===',
				'value'   => 'geolocation',
			],
		],
	],
	'map_control'    => [
		'type'        => 'panel',
		'group'       => 'facet_styles_panels',
		'title'       => __( 'Map', 'wpgb-map-facet' ),
		'clearButton' => true,
		'fields'      => [
			'map_height' => [
				'type'      => 'range',
				'label'     => __( 'Height', 'wpgb-map-facet' ),
				'units'     => [
					'custom' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 0.01,
					],
					'px'     => [
						'min'  => 0,
						'max'  => 999,
						'step' => 1,
					],
					'em'     => [
						'min'  => 0,
						'max'  => 100,
						'step' => 0.01,
					],
					'rem'    => [
						'min'  => 0,
						'max'  => 100,
						'step' => 0.01,
					],
					'%'      => [
						'min'  => 0,
						'max'  => 100,
						'step' => 0.01,
					],
					'vh'     => [
						'min'  => 0,
						'max'  => 100,
						'step' => 0.01,
					],
				],
				'selectors' => [
					'{{wrapper}} .wpgb-map-facet' => [
						'padding' => '0 !important',
						'height'  => '{{value}}',
					],
				],
			],
			'map_width'  => [
				'type'      => 'range',
				'label'     => __( 'Width', 'wpgb-map-facet' ),
				'units'     => [
					'custom' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 0.01,
					],
					'px'     => [
						'min'  => 0,
						'max'  => 999,
						'step' => 1,
					],
					'em'     => [
						'min'  => 0,
						'max'  => 100,
						'step' => 0.01,
					],
					'rem'    => [
						'min'  => 0,
						'max'  => 100,
						'step' => 0.01,
					],
					'%'      => [
						'min'  => 0,
						'max'  => 100,
						'step' => 0.01,
					],
					'vw'     => [
						'min'  => 0,
						'max'  => 100,
						'step' => 0.01,
					],
				],
				'selectors' => [
					'{{wrapper}} .wpgb-map-facet' => [
						'width' => '{{value}}',
					],
				],
			],
		],
		'condition'   => [
			[
				'field'   => 'type',
				'compare' => '===',
				'value'   => 'map',
			],
		],
	],
];
