<?php
/**
 * Grid defaults
 *
 * @package   WP Grid Builder
 * @author    Loïc Blascos
 * @copyright 2019-2024 Loïc Blascos
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

return [
	// Naming.
	'id'                           => '',
	'name'                         => '',
	// Query.
	'source'                       => 'post_type',
	'posts_per_page'               => 10,
	'offset'                       => 0,
	'post_order'                   => [],
	'term_order'                   => [],
	'user_order'                   => [],
	'post_type'                    => [ 'post' ],
	'post_status'                  => [ 'publish' ],
	'author__in'                   => [],
	'post__in'                     => [],
	'post__not_in'                 => [],
	'post_mime_type'               => '',
	'attachment_ids'               => [],
	'ignore_sticky_posts'          => false,
	'taxonomy'                     => [],
	'term__in'                     => [],
	'term__not_in'                 => [],
	'hide_empty'                   => false,
	'childless'                    => false,
	'role'                         => [],
	'role__in'                     => [],
	'role__not_in'                 => [],
	'user__in'                     => [],
	'user__not_in'                 => [],
	'has_published_posts'          => [],
	'tax_query_clauses'            => [],
	'meta_query_clauses'           => [],
	// Layout.
	'type'                         => 'masonry',
	'full_width'                   => 0,
	'horizontal_order'             => 0,
	'fit_rows'                     => 0,
	'equal_rows'                   => 0,
	'equal_columns'                => 0,
	'fill_last_row'                => 0,
	'center_last_row'              => 0,
	'card_sizes'                   => [
		[
			'browser' => 9999,
			'columns' => 4,
			'height'  => 240,
			'gutter'  => 16,
			'ratio'   => [
				'x' => 4,
				'y' => 3,
			],
		],
		[
			'browser' => 1280,
			'columns' => 3,
			'height'  => 220,
			'gutter'  => 16,
			'ratio'   => [
				'x' => 4,
				'y' => 3,
			],
		],
		[
			'browser' => 1024,
			'columns' => 2,
			'height'  => 200,
			'gutter'  => 16,
			'ratio'   => [
				'x' => 4,
				'y' => 3,
			],
		],
		[
			'browser' => 640,
			'columns' => 1,
			'height'  => 200,
			'gutter'  => 16,
			'ratio'   => [
				'x' => 4,
				'y' => 3,
			],
		],
	],
	'grid_layout'                  => [],
	// Carousel.
	'carousel'                     => 0,
	'slide_align'                  => 'left',
	'initial_index'                => 0,
	'group_cells'                  => 1,
	'rows_number'                  => 1,
	'auto_play'                    => 0,
	'contain'                      => 0,
	'prev_next_buttons_color'      => '#333333',
	'prev_next_buttons_background' => '',
	'page_dots_color'              => '#cccccc',
	'page_dots_selected_color'     => '#333333',
	'prev_next_buttons_size'       => '48px',
	'draggable'                    => 1,
	'free_scroll'                  => 0,
	'attraction'                   => '0.025',
	'friction'                     => '0.285',
	'free_friction'                => '0.075',
	// Cards.
	'card_types'                   => [],
	'columns'                      => '',
	'rows'                         => '',
	'animation'                    => '',
	'timing_function'              => 'ease',
	'cubic_bezier_function'        => 'cubic-bezier(0.1,0.3,0.2,1)',
	'transition'                   => 700,
	'transition_delay'             => 100,
	'loader_type'                  => '',
	'loader_color'                 => 'var(--wpgb-accent-scheme-1)',
	'loader_size'                  => 1,
	'content_background'           => '',
	'content_color_scheme'         => '',
	'overlay_background'           => '',
	'overlay_color_scheme'         => '',
	// Media.
	'post_formats'                 => [ 'gallery', 'video', 'audio' ],
	'first_media'                  => 0,
	'gallery_slideshow'            => 0,
	'product_image_hover'          => 0,
	'embedded_video_poster'        => 0,
	'video_lightbox'               => 0,
	'thumbnail_ratio'              => [
		'x' => '',
		'y' => '',
	],
	'thumbnail_size'               => 'medium_large',
	'thumbnail_size_mobile'        => 'medium_large',
	'default_thumbnail'            => 0,
	'lazy_load'                    => 0,
	'lazy_load_spinner'            => 0,
	'lazy_load_blurred_image'      => 0,
	'lazy_load_background'         => '',
	'lazy_load_spinner_color'      => '',
	// Advanced.
	'no_posts_msg'                 => '',
	'no_results_msg'               => '',
	'class'                        => '',
	'custom_css'                   => '',
	'custom_js'                    => '',
	// Gutenberg.
	'align'                        => '',
	'className'                    => '',
	// Helpers.
	'is_main_query'                => false,
	'is_overview'                  => false,
	'is_preview'                   => false,
	'is_dynamic'                   => false,
	'is_gutenberg'                 => false,
	'inline_style'                 => false,
	// Hidden settings (fallback).
	'order'                        => 'DESC',
	'orderby'                      => [],
	'user_orderby'                 => [],
	'term_orderby'                 => [],
	'meta_key'                     => '',
	'tax_query'                    => [],
	'tax_query_operator'           => 'IN',
	'tax_query_relation'           => 'OR',
	'tax_query_children'           => '',
	'meta_query'                   => [],
	'thumbnail_aspect'             => '',
	'override_card_sizes'          => 0,
	'layout'                       => 'vertical',
	'loader'                       => 0,
	'cards'                        => [],
	// Dynamic variables.
	/* translators: %s: Carousel page dot selected placeholder */
	'page_dot_aria_label'          => sprintf( esc_html__( 'Page dot %s', 'wp-grid-builder' ), '%d' ),
	'no_found_rows'                => false,
	'permalink'                    => '',
	'main_query'                   => [],
	'reveal'                       => 0,
	'error'                        => '',
	'facets'                       => [],
	'lang'                         => '',
	// Frontend options.
	'js_options'                   => [
		'id'                  => '',
		'type'                => '',
		'source'              => '',
		'loader'              => '',
		'layout'              => '',
		'reveal'              => '',
		'is_main_query'       => '',
		'lazy_load'           => '',
		'card_sizes'          => '',
		'fit_rows'            => '',
		'equal_rows'          => '',
		'equal_columns'       => '',
		'fill_last_row'       => '',
		'center_last_row'     => '',
		'horizontal_order'    => '',
		'full_width'          => '',
		'transition_delay'    => '',
		'gallery_slideshow'   => '',
		'rows_number'         => '',
		'slide_align'         => '',
		'group_cells'         => '',
		'draggable'           => '',
		'initial_index'       => '',
		'contain'             => '',
		'free_scroll'         => '',
		'free_friction'       => '',
		'friction'            => '',
		'attraction'          => '',
		'auto_play'           => '',
		'page_dot_aria_label' => '',
		'is_preview'          => '',
		'is_gutenberg'        => '',
	],
];
