<?php
/**
 * Icons
 *
 * @package   WP Grid Builder
 * @author    Loïc Blascos
 * @copyright 2019-2024 Loïc Blascos
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$svg_symbol = WPGB_URL . 'public/svg/sprite.svg#';
$svg_path   = WPGB_PATH . 'public/svg/';
$svg_url    = WPGB_URL . 'public/svg/';

return [
	'wpgb/animals/bug'                          => [
		'title'  => 'bug',
		'symbol' => $svg_symbol . 'animals/bug',
		'path'   => $svg_path . 'animals/bug.svg',
		'url'    => $svg_url . 'animals/bug.svg#wpgb-icon',
	],
	'wpgb/animals/bear'                         => [
		'title'  => 'bear',
		'symbol' => $svg_symbol . 'animals/bear',
		'path'   => $svg_path . 'animals/bear.svg',
		'url'    => $svg_url . 'animals/bear.svg#wpgb-icon',
	],
	'wpgb/animals/cat'                          => [
		'title'  => 'cat',
		'symbol' => $svg_symbol . 'animals/cat',
		'path'   => $svg_path . 'animals/cat.svg',
		'url'    => $svg_url . 'animals/cat.svg#wpgb-icon',
	],
	'wpgb/animals/chicken'                      => [
		'title'  => 'chicken',
		'symbol' => $svg_symbol . 'animals/chicken',
		'path'   => $svg_path . 'animals/chicken.svg',
		'url'    => $svg_url . 'animals/chicken.svg#wpgb-icon',
	],
	'wpgb/animals/crab'                         => [
		'title'  => 'crab',
		'symbol' => $svg_symbol . 'animals/crab',
		'path'   => $svg_path . 'animals/crab.svg',
		'url'    => $svg_url . 'animals/crab.svg#wpgb-icon',
	],
	'wpgb/animals/dog'                          => [
		'title'  => 'dog',
		'symbol' => $svg_symbol . 'animals/dog',
		'path'   => $svg_path . 'animals/dog.svg',
		'url'    => $svg_url . 'animals/dog.svg#wpgb-icon',
	],
	'wpgb/animals/octopus'                      => [
		'title'  => 'octopus',
		'symbol' => $svg_symbol . 'animals/octopus',
		'path'   => $svg_path . 'animals/octopus.svg',
		'url'    => $svg_url . 'animals/octopus.svg#wpgb-icon',
	],
	'wpgb/animals/panda'                        => [
		'title'  => 'panda',
		'symbol' => $svg_symbol . 'animals/panda',
		'path'   => $svg_path . 'animals/panda.svg',
		'url'    => $svg_url . 'animals/panda.svg#wpgb-icon',
	],
	'wpgb/animals/paw'                          => [
		'title'  => 'paw',
		'symbol' => $svg_symbol . 'animals/paw',
		'path'   => $svg_path . 'animals/paw.svg',
		'url'    => $svg_url . 'animals/paw.svg#wpgb-icon',
	],
	'wpgb/animals/rat'                          => [
		'title'  => 'rat',
		'symbol' => $svg_symbol . 'animals/rat',
		'path'   => $svg_path . 'animals/rat.svg',
		'url'    => $svg_url . 'animals/rat.svg#wpgb-icon',
	],
	'wpgb/clothes/cap'                          => [
		'title'  => 'cap',
		'symbol' => $svg_symbol . 'clothes/cap',
		'path'   => $svg_path . 'clothes/cap.svg',
		'url'    => $svg_url . 'clothes/cap.svg#wpgb-icon',
	],
	'wpgb/clothes/corset'                       => [
		'title'  => 'corset',
		'symbol' => $svg_symbol . 'clothes/corset',
		'path'   => $svg_path . 'clothes/corset.svg',
		'url'    => $svg_url . 'clothes/corset.svg#wpgb-icon',
	],
	'wpgb/clothes/dress'                        => [
		'title'  => 'dress',
		'symbol' => $svg_symbol . 'clothes/dress',
		'path'   => $svg_path . 'clothes/dress.svg',
		'url'    => $svg_url . 'clothes/dress.svg#wpgb-icon',
	],
	'wpgb/clothes/shirt'                        => [
		'title'  => 'shirt',
		'symbol' => $svg_symbol . 'clothes/shirt',
		'path'   => $svg_path . 'clothes/shirt.svg',
		'url'    => $svg_url . 'clothes/shirt.svg#wpgb-icon',
	],
	'wpgb/clothes/shoe'                         => [
		'title'  => 'shoe',
		'symbol' => $svg_symbol . 'clothes/shoe',
		'path'   => $svg_path . 'clothes/shoe.svg',
		'url'    => $svg_url . 'clothes/shoe.svg#wpgb-icon',
	],
	'wpgb/clothes/slacks'                       => [
		'title'  => 'slacks',
		'symbol' => $svg_symbol . 'clothes/slacks',
		'path'   => $svg_path . 'clothes/slacks.svg',
		'url'    => $svg_url . 'clothes/slacks.svg#wpgb-icon',
	],
	'wpgb/clothes/sock'                         => [
		'title'  => 'sock',
		'symbol' => $svg_symbol . 'clothes/sock',
		'path'   => $svg_path . 'clothes/sock.svg',
		'url'    => $svg_url . 'clothes/sock.svg#wpgb-icon',
	],
	'wpgb/clothes/tie'                          => [
		'title'  => 'tie',
		'symbol' => $svg_symbol . 'clothes/tie',
		'path'   => $svg_path . 'clothes/tie.svg',
		'url'    => $svg_url . 'clothes/tie.svg#wpgb-icon',
	],
	'wpgb/clothes/tshirt'                       => [
		'title'  => 'tshirt',
		'symbol' => $svg_symbol . 'clothes/tshirt',
		'path'   => $svg_path . 'clothes/tshirt.svg',
		'url'    => $svg_url . 'clothes/tshirt.svg#wpgb-icon',
	],
	'wpgb/clothes/underwear'                    => [
		'title'  => 'underwear',
		'symbol' => $svg_symbol . 'clothes/underwear',
		'path'   => $svg_path . 'clothes/underwear.svg',
		'url'    => $svg_url . 'clothes/underwear.svg#wpgb-icon',
	],
	'wpgb/social-media/behance'                 => [
		'title'  => 'behance',
		'symbol' => $svg_symbol . 'social-media/behance',
		'path'   => $svg_path . 'social-media/behance.svg',
		'url'    => $svg_url . 'social-media/behance.svg#wpgb-icon',
	],
	'wpgb/social-media/blogger'                 => [
		'title'  => 'blogger',
		'symbol' => $svg_symbol . 'social-media/blogger',
		'path'   => $svg_path . 'social-media/blogger.svg',
		'url'    => $svg_url . 'social-media/blogger.svg#wpgb-icon',
	],
	'wpgb/social-media/buffer'                  => [
		'title'  => 'buffer',
		'symbol' => $svg_symbol . 'social-media/buffer',
		'path'   => $svg_path . 'social-media/buffer.svg',
		'url'    => $svg_url . 'social-media/buffer.svg#wpgb-icon',
	],
	'wpgb/social-media/dribbble'                => [
		'title'  => 'dribbble',
		'symbol' => $svg_symbol . 'social-media/dribbble',
		'path'   => $svg_path . 'social-media/dribbble.svg',
		'url'    => $svg_url . 'social-media/dribbble.svg#wpgb-icon',
	],
	'wpgb/social-media/dropbox'                 => [
		'title'  => 'dropbox',
		'symbol' => $svg_symbol . 'social-media/dropbox',
		'path'   => $svg_path . 'social-media/dropbox.svg',
		'url'    => $svg_url . 'social-media/dropbox.svg#wpgb-icon',
	],
	'wpgb/social-media/email'                   => [
		'title'  => 'email',
		'symbol' => $svg_symbol . 'social-media/email',
		'path'   => $svg_path . 'social-media/email.svg',
		'url'    => $svg_url . 'social-media/email.svg#wpgb-icon',
	],
	'wpgb/social-media/evernote'                => [
		'title'  => 'evernote',
		'symbol' => $svg_symbol . 'social-media/evernote',
		'path'   => $svg_path . 'social-media/evernote.svg',
		'url'    => $svg_url . 'social-media/evernote.svg#wpgb-icon',
	],
	'wpgb/social-media/facebook'                => [
		'title'  => 'facebook',
		'symbol' => $svg_symbol . 'social-media/facebook',
		'path'   => $svg_path . 'social-media/facebook.svg',
		'url'    => $svg_url . 'social-media/facebook.svg#wpgb-icon',
	],
	'wpgb/social-media/flickr'                  => [
		'title'  => 'flickr',
		'symbol' => $svg_symbol . 'social-media/flickr',
		'path'   => $svg_path . 'social-media/flickr.svg',
		'url'    => $svg_url . 'social-media/flickr.svg#wpgb-icon',
	],
	'wpgb/social-media/github'                  => [
		'title'  => 'github',
		'symbol' => $svg_symbol . 'social-media/github',
		'path'   => $svg_path . 'social-media/github.svg',
		'url'    => $svg_url . 'social-media/github.svg#wpgb-icon',
	],
	'wpgb/social-media/google-plus'             => [
		'title'  => 'google plus',
		'symbol' => $svg_symbol . 'social-media/google-plus',
		'path'   => $svg_path . 'social-media/google-plus.svg',
		'url'    => $svg_url . 'social-media/google-plus.svg#wpgb-icon',
	],
	'wpgb/social-media/instagram'               => [
		'title'  => 'instagram',
		'symbol' => $svg_symbol . 'social-media/instagram',
		'path'   => $svg_path . 'social-media/instagram.svg',
		'url'    => $svg_url . 'social-media/instagram.svg#wpgb-icon',
	],
	'wpgb/social-media/linkedin'                => [
		'title'  => 'linkedin',
		'symbol' => $svg_symbol . 'social-media/linkedin',
		'path'   => $svg_path . 'social-media/linkedin.svg',
		'url'    => $svg_url . 'social-media/linkedin.svg#wpgb-icon',
	],
	'wpgb/social-media/messenger'               => [
		'title'  => 'messenger',
		'symbol' => $svg_symbol . 'social-media/messenger',
		'path'   => $svg_path . 'social-media/messenger.svg',
		'url'    => $svg_url . 'social-media/messenger.svg#wpgb-icon',
	],
	'wpgb/social-media/paypal'                  => [
		'title'  => 'paypal',
		'symbol' => $svg_symbol . 'social-media/paypal',
		'path'   => $svg_path . 'social-media/paypal.svg',
		'url'    => $svg_url . 'social-media/paypal.svg#wpgb-icon',
	],
	'wpgb/social-media/pinterest'               => [
		'title'  => 'pinterest',
		'symbol' => $svg_symbol . 'social-media/pinterest',
		'path'   => $svg_path . 'social-media/pinterest.svg',
		'url'    => $svg_url . 'social-media/pinterest.svg#wpgb-icon',
	],
	'wpgb/social-media/reddit'                  => [
		'title'  => 'reddit',
		'symbol' => $svg_symbol . 'social-media/reddit',
		'path'   => $svg_path . 'social-media/reddit.svg',
		'url'    => $svg_url . 'social-media/reddit.svg#wpgb-icon',
	],
	'wpgb/social-media/rss'                     => [
		'title'  => 'rss',
		'symbol' => $svg_symbol . 'social-media/rss',
		'path'   => $svg_path . 'social-media/rss.svg',
		'url'    => $svg_url . 'social-media/rss.svg#wpgb-icon',
	],
	'wpgb/social-media/skype'                   => [
		'title'  => 'skype',
		'symbol' => $svg_symbol . 'social-media/skype',
		'path'   => $svg_path . 'social-media/skype.svg',
		'url'    => $svg_url . 'social-media/skype.svg#wpgb-icon',
	],
	'wpgb/social-media/slack'                   => [
		'title'  => 'slack',
		'symbol' => $svg_symbol . 'social-media/slack',
		'path'   => $svg_path . 'social-media/slack.svg',
		'url'    => $svg_url . 'social-media/slack.svg#wpgb-icon',
	],
	'wpgb/social-media/soundcloud'              => [
		'title'  => 'soundcloud',
		'symbol' => $svg_symbol . 'social-media/soundcloud',
		'path'   => $svg_path . 'social-media/soundcloud.svg',
		'url'    => $svg_url . 'social-media/soundcloud.svg#wpgb-icon',
	],
	'wpgb/social-media/spotify'                 => [
		'title'  => 'spotify',
		'symbol' => $svg_symbol . 'social-media/spotify',
		'path'   => $svg_path . 'social-media/spotify.svg',
		'url'    => $svg_url . 'social-media/spotify.svg#wpgb-icon',
	],
	'wpgb/social-media/tumblr'                  => [
		'title'  => 'tumblr',
		'symbol' => $svg_symbol . 'social-media/tumblr',
		'path'   => $svg_path . 'social-media/tumblr.svg',
		'url'    => $svg_url . 'social-media/tumblr.svg#wpgb-icon',
	],
	'wpgb/social-media/twitter'                 => [
		'title'  => 'X (twitter)',
		'symbol' => $svg_symbol . 'social-media/twitter',
		'path'   => $svg_path . 'social-media/twitter.svg',
		'url'    => $svg_url . 'social-media/twitter.svg#wpgb-icon',
	],
	'wpgb/social-media/vimeo'                   => [
		'title'  => 'vimeo',
		'symbol' => $svg_symbol . 'social-media/vimeo',
		'path'   => $svg_path . 'social-media/vimeo.svg',
		'url'    => $svg_url . 'social-media/vimeo.svg#wpgb-icon',
	],
	'wpgb/social-media/vine'                    => [
		'title'  => 'vine',
		'symbol' => $svg_symbol . 'social-media/vine',
		'path'   => $svg_path . 'social-media/vine.svg',
		'url'    => $svg_url . 'social-media/vine.svg#wpgb-icon',
	],
	'wpgb/social-media/vkontakte'               => [
		'title'  => 'vkontakte',
		'symbol' => $svg_symbol . 'social-media/vkontakte',
		'path'   => $svg_path . 'social-media/vkontakte.svg',
		'url'    => $svg_url . 'social-media/vkontakte.svg#wpgb-icon',
	],
	'wpgb/social-media/whatsapp'                => [
		'title'  => 'whatsapp',
		'symbol' => $svg_symbol . 'social-media/whatsapp',
		'path'   => $svg_path . 'social-media/whatsapp.svg',
		'url'    => $svg_url . 'social-media/whatsapp.svg#wpgb-icon',
	],
	'wpgb/social-media/wordpress'               => [
		'title'  => 'wordpress',
		'symbol' => $svg_symbol . 'social-media/wordpress',
		'path'   => $svg_path . 'social-media/wordpress.svg',
		'url'    => $svg_url . 'social-media/wordpress.svg#wpgb-icon',
	],
	'wpgb/social-media/yelp'                    => [
		'title'  => 'yelp',
		'symbol' => $svg_symbol . 'social-media/yelp',
		'path'   => $svg_path . 'social-media/yelp.svg',
		'url'    => $svg_url . 'social-media/yelp.svg#wpgb-icon',
	],
	'wpgb/social-media/youtube'                 => [
		'title'  => 'youtube',
		'symbol' => $svg_symbol . 'social-media/youtube',
		'path'   => $svg_path . 'social-media/youtube.svg',
		'url'    => $svg_url . 'social-media/youtube.svg#wpgb-icon',
	],
	'wpgb/business/bag-1'                       => [
		'title'  => 'bag',
		'symbol' => $svg_symbol . 'business/bag-1',
		'path'   => $svg_path . 'business/bag-1.svg',
		'url'    => $svg_url . 'business/bag-1.svg#wpgb-icon',
	],
	'wpgb/business/bag-2'                       => [
		'title'  => 'bag',
		'symbol' => $svg_symbol . 'business/bag-2',
		'path'   => $svg_path . 'business/bag-2.svg',
		'url'    => $svg_url . 'business/bag-2.svg#wpgb-icon',
	],
	'wpgb/business/bag-3'                       => [
		'title'  => 'bag',
		'symbol' => $svg_symbol . 'business/bag-3',
		'path'   => $svg_path . 'business/bag-3.svg',
		'url'    => $svg_url . 'business/bag-3.svg#wpgb-icon',
	],
	'wpgb/business/bag-add'                     => [
		'title'  => 'bag add',
		'symbol' => $svg_symbol . 'business/bag-add',
		'path'   => $svg_path . 'business/bag-add.svg',
		'url'    => $svg_url . 'business/bag-add.svg#wpgb-icon',
	],
	'wpgb/business/basket-1'                    => [
		'title'  => 'basket',
		'symbol' => $svg_symbol . 'business/basket-1',
		'path'   => $svg_path . 'business/basket-1.svg',
		'url'    => $svg_url . 'business/basket-1.svg#wpgb-icon',
	],
	'wpgb/business/basket-2'                    => [
		'title'  => 'basket',
		'symbol' => $svg_symbol . 'business/basket-2',
		'path'   => $svg_path . 'business/basket-2.svg',
		'url'    => $svg_url . 'business/basket-2.svg#wpgb-icon',
	],
	'wpgb/business/basket-add'                  => [
		'title'  => 'basket add',
		'symbol' => $svg_symbol . 'business/basket-add',
		'path'   => $svg_path . 'business/basket-add.svg',
		'url'    => $svg_url . 'business/basket-add.svg#wpgb-icon',
	],
	'wpgb/business/cart-1'                      => [
		'title'  => 'cart',
		'symbol' => $svg_symbol . 'business/cart-1',
		'path'   => $svg_path . 'business/cart-1.svg',
		'url'    => $svg_url . 'business/cart-1.svg#wpgb-icon',
	],
	'wpgb/business/cart-2'                      => [
		'title'  => 'cart',
		'symbol' => $svg_symbol . 'business/cart-2',
		'path'   => $svg_path . 'business/cart-2.svg',
		'url'    => $svg_url . 'business/cart-2.svg#wpgb-icon',
	],
	'wpgb/business/cart-3'                      => [
		'title'  => 'cart',
		'symbol' => $svg_symbol . 'business/cart-3',
		'path'   => $svg_path . 'business/cart-3.svg',
		'url'    => $svg_url . 'business/cart-3.svg#wpgb-icon',
	],
	'wpgb/business/cart-add'                    => [
		'title'  => 'cart add',
		'symbol' => $svg_symbol . 'business/cart-add',
		'path'   => $svg_path . 'business/cart-add.svg',
		'url'    => $svg_url . 'business/cart-add.svg#wpgb-icon',
	],
	'wpgb/business/coupon'                      => [
		'title'  => 'coupon',
		'symbol' => $svg_symbol . 'business/coupon',
		'path'   => $svg_path . 'business/coupon.svg',
		'url'    => $svg_url . 'business/coupon.svg#wpgb-icon',
	],
	'wpgb/business/credit-card'                 => [
		'title'  => 'credit card',
		'symbol' => $svg_symbol . 'business/credit-card',
		'path'   => $svg_path . 'business/credit-card.svg',
		'url'    => $svg_url . 'business/credit-card.svg#wpgb-icon',
	],
	'wpgb/business/currency-dollar'             => [
		'title'  => 'currency dollar',
		'symbol' => $svg_symbol . 'business/currency-dollar',
		'path'   => $svg_path . 'business/currency-dollar.svg',
		'url'    => $svg_url . 'business/currency-dollar.svg#wpgb-icon',
	],
	'wpgb/business/currency-euro'               => [
		'title'  => 'currency euro',
		'symbol' => $svg_symbol . 'business/currency-euro',
		'path'   => $svg_path . 'business/currency-euro.svg',
		'url'    => $svg_url . 'business/currency-euro.svg#wpgb-icon',
	],
	'wpgb/business/currency-pound'              => [
		'title'  => 'currency pound',
		'symbol' => $svg_symbol . 'business/currency-pound',
		'path'   => $svg_path . 'business/currency-pound.svg',
		'url'    => $svg_url . 'business/currency-pound.svg#wpgb-icon',
	],
	'wpgb/business/currency-yen'                => [
		'title'  => 'currency yen',
		'symbol' => $svg_symbol . 'business/currency-yen',
		'path'   => $svg_path . 'business/currency-yen.svg',
		'url'    => $svg_url . 'business/currency-yen.svg#wpgb-icon',
	],
	'wpgb/business/delivery-fast'               => [
		'title'  => 'delivery fast',
		'symbol' => $svg_symbol . 'business/delivery-fast',
		'path'   => $svg_path . 'business/delivery-fast.svg',
		'url'    => $svg_url . 'business/delivery-fast.svg#wpgb-icon',
	],
	'wpgb/business/discount-1'                  => [
		'title'  => 'discount',
		'symbol' => $svg_symbol . 'business/discount-1',
		'path'   => $svg_path . 'business/discount-1.svg',
		'url'    => $svg_url . 'business/discount-1.svg#wpgb-icon',
	],
	'wpgb/business/discount-2'                  => [
		'title'  => 'discount',
		'symbol' => $svg_symbol . 'business/discount-2',
		'path'   => $svg_path . 'business/discount-2.svg',
		'url'    => $svg_url . 'business/discount-2.svg#wpgb-icon',
	],
	'wpgb/business/gift'                        => [
		'title'  => 'gift',
		'symbol' => $svg_symbol . 'business/gift',
		'path'   => $svg_path . 'business/gift.svg',
		'url'    => $svg_url . 'business/gift.svg#wpgb-icon',
	],
	'wpgb/business/money-coins'                 => [
		'title'  => 'money coins',
		'symbol' => $svg_symbol . 'business/money-coins',
		'path'   => $svg_path . 'business/money-coins.svg',
		'url'    => $svg_url . 'business/money-coins.svg#wpgb-icon',
	],
	'wpgb/business/piggy-bank'                  => [
		'title'  => 'piggy bank',
		'symbol' => $svg_symbol . 'business/piggy-bank',
		'path'   => $svg_path . 'business/piggy-bank.svg',
		'url'    => $svg_url . 'business/piggy-bank.svg#wpgb-icon',
	],
	'wpgb/business/shop'                        => [
		'title'  => 'shop',
		'symbol' => $svg_symbol . 'business/shop',
		'path'   => $svg_path . 'business/shop.svg',
		'url'    => $svg_url . 'business/shop.svg#wpgb-icon',
	],
	'wpgb/business/tag-content'                 => [
		'title'  => 'tag content',
		'symbol' => $svg_symbol . 'business/tag-content',
		'path'   => $svg_path . 'business/tag-content.svg',
		'url'    => $svg_url . 'business/tag-content.svg#wpgb-icon',
	],
	'wpgb/business/tag-cut'                     => [
		'title'  => 'tag cut',
		'symbol' => $svg_symbol . 'business/tag-cut',
		'path'   => $svg_path . 'business/tag-cut.svg',
		'url'    => $svg_url . 'business/tag-cut.svg#wpgb-icon',
	],
	'wpgb/business/wallet-1'                    => [
		'title'  => 'wallet',
		'symbol' => $svg_symbol . 'business/wallet-1',
		'path'   => $svg_path . 'business/wallet-1.svg',
		'url'    => $svg_url . 'business/wallet-1.svg#wpgb-icon',
	],
	'wpgb/business/wallet-2'                    => [
		'title'  => 'wallet',
		'symbol' => $svg_symbol . 'business/wallet-2',
		'path'   => $svg_path . 'business/wallet-2.svg',
		'url'    => $svg_url . 'business/wallet-2.svg#wpgb-icon',
	],
	'wpgb/technology/android'                   => [
		'title'  => 'android',
		'symbol' => $svg_symbol . 'technology/android',
		'path'   => $svg_path . 'technology/android.svg',
		'url'    => $svg_url . 'technology/android.svg#wpgb-icon',
	],
	'wpgb/technology/battery-level'             => [
		'title'  => 'battery level',
		'symbol' => $svg_symbol . 'technology/battery-level',
		'path'   => $svg_path . 'technology/battery-level.svg',
		'url'    => $svg_url . 'technology/battery-level.svg#wpgb-icon',
	],
	'wpgb/technology/controller'                => [
		'title'  => 'controller',
		'symbol' => $svg_symbol . 'technology/controller',
		'path'   => $svg_path . 'technology/controller.svg',
		'url'    => $svg_url . 'technology/controller.svg#wpgb-icon',
	],
	'wpgb/technology/cursor'                    => [
		'title'  => 'cursor',
		'symbol' => $svg_symbol . 'technology/cursor',
		'path'   => $svg_path . 'technology/cursor.svg',
		'url'    => $svg_url . 'technology/cursor.svg#wpgb-icon',
	],
	'wpgb/technology/desktop-screen'            => [
		'title'  => 'desktop screen',
		'symbol' => $svg_symbol . 'technology/desktop-screen',
		'path'   => $svg_path . 'technology/desktop-screen.svg',
		'url'    => $svg_url . 'technology/desktop-screen.svg#wpgb-icon',
	],
	'wpgb/technology/disk-reader'               => [
		'title'  => 'disk reader',
		'symbol' => $svg_symbol . 'technology/disk-reader',
		'path'   => $svg_path . 'technology/disk-reader.svg',
		'url'    => $svg_url . 'technology/disk-reader.svg#wpgb-icon',
	],
	'wpgb/technology/engine-start'              => [
		'title'  => 'engine start',
		'symbol' => $svg_symbol . 'technology/engine-start',
		'path'   => $svg_path . 'technology/engine-start.svg',
		'url'    => $svg_url . 'technology/engine-start.svg#wpgb-icon',
	],
	'wpgb/technology/headphones'                => [
		'title'  => 'headphones',
		'symbol' => $svg_symbol . 'technology/headphones',
		'path'   => $svg_path . 'technology/headphones.svg',
		'url'    => $svg_url . 'technology/headphones.svg#wpgb-icon',
	],
	'wpgb/technology/keyboard'                  => [
		'title'  => 'keyboard',
		'symbol' => $svg_symbol . 'technology/keyboard',
		'path'   => $svg_path . 'technology/keyboard.svg',
		'url'    => $svg_url . 'technology/keyboard.svg#wpgb-icon',
	],
	'wpgb/technology/laptop'                    => [
		'title'  => 'laptop',
		'symbol' => $svg_symbol . 'technology/laptop',
		'path'   => $svg_path . 'technology/laptop.svg',
		'url'    => $svg_url . 'technology/laptop.svg#wpgb-icon',
	],
	'wpgb/technology/mobile'                    => [
		'title'  => 'mobile',
		'symbol' => $svg_symbol . 'technology/mobile',
		'path'   => $svg_path . 'technology/mobile.svg',
		'url'    => $svg_url . 'technology/mobile.svg#wpgb-icon',
	],
	'wpgb/technology/mouse'                     => [
		'title'  => 'mouse',
		'symbol' => $svg_symbol . 'technology/mouse',
		'path'   => $svg_path . 'technology/mouse.svg',
		'url'    => $svg_url . 'technology/mouse.svg#wpgb-icon',
	],
	'wpgb/technology/printer'                   => [
		'title'  => 'printer',
		'symbol' => $svg_symbol . 'technology/printer',
		'path'   => $svg_path . 'technology/printer.svg',
		'url'    => $svg_url . 'technology/printer.svg#wpgb-icon',
	],
	'wpgb/technology/sim-card'                  => [
		'title'  => 'sim card',
		'symbol' => $svg_symbol . 'technology/sim-card',
		'path'   => $svg_path . 'technology/sim-card.svg',
		'url'    => $svg_url . 'technology/sim-card.svg#wpgb-icon',
	],
	'wpgb/technology/tv-old'                    => [
		'title'  => 'tv old',
		'symbol' => $svg_symbol . 'technology/tv-old',
		'path'   => $svg_path . 'technology/tv-old.svg',
		'url'    => $svg_url . 'technology/tv-old.svg#wpgb-icon',
	],
	'wpgb/technology/watch-circle'              => [
		'title'  => 'watch circle',
		'symbol' => $svg_symbol . 'technology/watch-circle',
		'path'   => $svg_path . 'technology/watch-circle.svg',
		'url'    => $svg_url . 'technology/watch-circle.svg#wpgb-icon',
	],
	'wpgb/technology/watch'                     => [
		'title'  => 'watch',
		'symbol' => $svg_symbol . 'technology/watch',
		'path'   => $svg_path . 'technology/watch.svg',
		'url'    => $svg_url . 'technology/watch.svg#wpgb-icon',
	],
	'wpgb/technology/wifi'                      => [
		'title'  => 'wifi',
		'symbol' => $svg_symbol . 'technology/wifi',
		'path'   => $svg_path . 'technology/wifi.svg',
		'url'    => $svg_url . 'technology/wifi.svg#wpgb-icon',
	],
	'wpgb/design/box'                           => [
		'title'  => 'box',
		'symbol' => $svg_symbol . 'design/box',
		'path'   => $svg_path . 'design/box.svg',
		'url'    => $svg_url . 'design/box.svg#wpgb-icon',
	],
	'wpgb/design/code'                          => [
		'title'  => 'code',
		'symbol' => $svg_symbol . 'design/code',
		'path'   => $svg_path . 'design/code.svg',
		'url'    => $svg_url . 'design/code.svg#wpgb-icon',
	],
	'wpgb/design/drop'                          => [
		'title'  => 'drop',
		'symbol' => $svg_symbol . 'design/drop',
		'path'   => $svg_path . 'design/drop.svg',
		'url'    => $svg_url . 'design/drop.svg#wpgb-icon',
	],
	'wpgb/design/image-1'                       => [
		'title'  => 'image',
		'symbol' => $svg_symbol . 'design/image-1',
		'path'   => $svg_path . 'design/image-1.svg',
		'url'    => $svg_url . 'design/image-1.svg#wpgb-icon',
	],
	'wpgb/design/image-2'                       => [
		'title'  => 'image',
		'symbol' => $svg_symbol . 'design/image-2',
		'path'   => $svg_path . 'design/image-2.svg',
		'url'    => $svg_url . 'design/image-2.svg#wpgb-icon',
	],
	'wpgb/design/layers'                        => [
		'title'  => 'layers',
		'symbol' => $svg_symbol . 'design/layers',
		'path'   => $svg_path . 'design/layers.svg',
		'url'    => $svg_url . 'design/layers.svg#wpgb-icon',
	],
	'wpgb/design/oval-shape'                    => [
		'title'  => 'oval shape',
		'symbol' => $svg_symbol . 'design/oval-shape',
		'path'   => $svg_path . 'design/oval-shape.svg',
		'url'    => $svg_url . 'design/oval-shape.svg#wpgb-icon',
	],
	'wpgb/design/paint-brush'                   => [
		'title'  => 'paint brush',
		'symbol' => $svg_symbol . 'design/paint-brush',
		'path'   => $svg_path . 'design/paint-brush.svg',
		'url'    => $svg_url . 'design/paint-brush.svg#wpgb-icon',
	],
	'wpgb/design/paint-bucket-1'                => [
		'title'  => 'paint bucket',
		'symbol' => $svg_symbol . 'design/paint-bucket-1',
		'path'   => $svg_path . 'design/paint-bucket-1.svg',
		'url'    => $svg_url . 'design/paint-bucket-1.svg#wpgb-icon',
	],
	'wpgb/design/paint-bucket-2'                => [
		'title'  => 'paint bucket',
		'symbol' => $svg_symbol . 'design/paint-bucket-2',
		'path'   => $svg_path . 'design/paint-bucket-2.svg',
		'url'    => $svg_url . 'design/paint-bucket-2.svg#wpgb-icon',
	],
	'wpgb/design/paint-roller'                  => [
		'title'  => 'paint roller',
		'symbol' => $svg_symbol . 'design/paint-roller',
		'path'   => $svg_path . 'design/paint-roller.svg',
		'url'    => $svg_url . 'design/paint-roller.svg#wpgb-icon',
	],
	'wpgb/design/palette'                       => [
		'title'  => 'palette',
		'symbol' => $svg_symbol . 'design/palette',
		'path'   => $svg_path . 'design/palette.svg',
		'url'    => $svg_url . 'design/palette.svg#wpgb-icon',
	],
	'wpgb/design/polygon-shape'                 => [
		'title'  => 'polygon shape',
		'symbol' => $svg_symbol . 'design/polygon-shape',
		'path'   => $svg_path . 'design/polygon-shape.svg',
		'url'    => $svg_url . 'design/polygon-shape.svg#wpgb-icon',
	],
	'wpgb/design/rectangle-shape'               => [
		'title'  => 'rectangle shape',
		'symbol' => $svg_symbol . 'design/rectangle-shape',
		'path'   => $svg_path . 'design/rectangle-shape.svg',
		'url'    => $svg_url . 'design/rectangle-shape.svg#wpgb-icon',
	],
	'wpgb/design/ruler'                         => [
		'title'  => 'ruler',
		'symbol' => $svg_symbol . 'design/ruler',
		'path'   => $svg_path . 'design/ruler.svg',
		'url'    => $svg_url . 'design/ruler.svg#wpgb-icon',
	],
	'wpgb/design/triangle-shape'                => [
		'title'  => 'triangle shape',
		'symbol' => $svg_symbol . 'design/triangle-shape',
		'path'   => $svg_path . 'design/triangle-shape.svg',
		'url'    => $svg_url . 'design/triangle-shape.svg#wpgb-icon',
	],
	'wpgb/files/file-download'                  => [
		'title'  => 'file download',
		'symbol' => $svg_symbol . 'files/file-download',
		'path'   => $svg_path . 'files/file-download.svg',
		'url'    => $svg_url . 'files/file-download.svg#wpgb-icon',
	],
	'wpgb/files/file-upload'                    => [
		'title'  => 'file upload',
		'symbol' => $svg_symbol . 'files/file-upload',
		'path'   => $svg_path . 'files/file-upload.svg',
		'url'    => $svg_url . 'files/file-upload.svg#wpgb-icon',
	],
	'wpgb/files/folder-1'                       => [
		'title'  => 'folder 1',
		'symbol' => $svg_symbol . 'files/folder-1',
		'path'   => $svg_path . 'files/folder-1.svg',
		'url'    => $svg_url . 'files/folder-1.svg#wpgb-icon',
	],
	'wpgb/files/folder-2'                       => [
		'title'  => 'folder 2',
		'symbol' => $svg_symbol . 'files/folder-2',
		'path'   => $svg_path . 'files/folder-2.svg',
		'url'    => $svg_url . 'files/folder-2.svg#wpgb-icon',
	],
	'wpgb/files/single-content'                 => [
		'title'  => 'single content',
		'symbol' => $svg_symbol . 'files/single-content',
		'path'   => $svg_path . 'files/single-content.svg',
		'url'    => $svg_url . 'files/single-content.svg#wpgb-icon',
	],
	'wpgb/files/single-copies'                  => [
		'title'  => 'single copies',
		'symbol' => $svg_symbol . 'files/single-copies',
		'path'   => $svg_path . 'files/single-copies.svg',
		'url'    => $svg_url . 'files/single-copies.svg#wpgb-icon',
	],
	'wpgb/files/single-copy'                    => [
		'title'  => 'single copy',
		'symbol' => $svg_symbol . 'files/single-copy',
		'path'   => $svg_path . 'files/single-copy.svg',
		'url'    => $svg_url . 'files/single-copy.svg#wpgb-icon',
	],
	'wpgb/user-interface/add-circle-glyph'      => [
		'title'  => 'add circle glyph',
		'symbol' => $svg_symbol . 'user-interface/add-circle-glyph',
		'path'   => $svg_path . 'user-interface/add-circle-glyph.svg',
		'url'    => $svg_url . 'user-interface/add-circle-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/add-circle'            => [
		'title'  => 'add circle',
		'symbol' => $svg_symbol . 'user-interface/add-circle',
		'path'   => $svg_path . 'user-interface/add-circle.svg',
		'url'    => $svg_url . 'user-interface/add-circle.svg#wpgb-icon',
	],
	'wpgb/user-interface/add-outline'           => [
		'title'  => 'add outline',
		'symbol' => $svg_symbol . 'user-interface/add-outline',
		'path'   => $svg_path . 'user-interface/add-outline.svg',
		'url'    => $svg_url . 'user-interface/add-outline.svg#wpgb-icon',
	],
	'wpgb/user-interface/add-square-glyph'      => [
		'title'  => 'add square glyph',
		'symbol' => $svg_symbol . 'user-interface/add-square-glyph',
		'path'   => $svg_path . 'user-interface/add-square-glyph.svg',
		'url'    => $svg_url . 'user-interface/add-square-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/add-square'            => [
		'title'  => 'add square',
		'symbol' => $svg_symbol . 'user-interface/add-square',
		'path'   => $svg_path . 'user-interface/add-square.svg',
		'url'    => $svg_url . 'user-interface/add-square.svg#wpgb-icon',
	],
	'wpgb/user-interface/add'                   => [
		'title'  => 'add',
		'symbol' => $svg_symbol . 'user-interface/add',
		'path'   => $svg_path . 'user-interface/add.svg',
		'url'    => $svg_url . 'user-interface/add.svg#wpgb-icon',
	],
	'wpgb/user-interface/calendar-1'            => [
		'title'  => 'calendar',
		'symbol' => $svg_symbol . 'user-interface/calendar-1',
		'path'   => $svg_path . 'user-interface/calendar-1.svg',
		'url'    => $svg_url . 'user-interface/calendar-1.svg#wpgb-icon',
	],
	'wpgb/user-interface/calendar-2'            => [
		'title'  => 'calendar',
		'symbol' => $svg_symbol . 'user-interface/calendar-2',
		'path'   => $svg_path . 'user-interface/calendar-2.svg',
		'url'    => $svg_url . 'user-interface/calendar-2.svg#wpgb-icon',
	],
	'wpgb/user-interface/calendar-3'            => [
		'title'  => 'calendar',
		'symbol' => $svg_symbol . 'user-interface/calendar-3',
		'path'   => $svg_path . 'user-interface/calendar-3.svg',
		'url'    => $svg_url . 'user-interface/calendar-3.svg#wpgb-icon',
	],
	'wpgb/user-interface/calendar-4'            => [
		'title'  => 'calendar',
		'symbol' => $svg_symbol . 'user-interface/calendar-4',
		'path'   => $svg_path . 'user-interface/calendar-4.svg',
		'url'    => $svg_url . 'user-interface/calendar-4.svg#wpgb-icon',
	],
	'wpgb/user-interface/calendar-5-glyph'      => [
		'title'  => 'calendar glyph',
		'symbol' => $svg_symbol . 'user-interface/calendar-5-glyph',
		'path'   => $svg_path . 'user-interface/calendar-5-glyph.svg',
		'url'    => $svg_url . 'user-interface/calendar-5-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/clip-1'                => [
		'title'  => 'clip',
		'symbol' => $svg_symbol . 'user-interface/clip-1',
		'path'   => $svg_path . 'user-interface/clip-1.svg',
		'url'    => $svg_url . 'user-interface/clip-1.svg#wpgb-icon',
	],
	'wpgb/user-interface/clip-2'                => [
		'title'  => 'clip',
		'symbol' => $svg_symbol . 'user-interface/clip-2',
		'path'   => $svg_path . 'user-interface/clip-2.svg',
		'url'    => $svg_url . 'user-interface/clip-2.svg#wpgb-icon',
	],
	'wpgb/user-interface/clock-1'               => [
		'title'  => 'clock',
		'symbol' => $svg_symbol . 'user-interface/clock-1',
		'path'   => $svg_path . 'user-interface/clock-1.svg',
		'url'    => $svg_url . 'user-interface/clock-1.svg#wpgb-icon',
	],
	'wpgb/user-interface/clock-2'               => [
		'title'  => 'clock',
		'symbol' => $svg_symbol . 'user-interface/clock-2',
		'path'   => $svg_path . 'user-interface/clock-2.svg',
		'url'    => $svg_url . 'user-interface/clock-2.svg#wpgb-icon',
	],
	'wpgb/user-interface/clock-3-glyph'         => [
		'title'  => 'clock glyph',
		'symbol' => $svg_symbol . 'user-interface/clock-3-glyph',
		'path'   => $svg_path . 'user-interface/clock-3-glyph.svg',
		'url'    => $svg_url . 'user-interface/clock-3-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/comment-1-glyph'       => [
		'title'  => 'comment glyph',
		'symbol' => $svg_symbol . 'user-interface/comment-1-glyph',
		'path'   => $svg_path . 'user-interface/comment-1-glyph.svg',
		'url'    => $svg_url . 'user-interface/comment-1-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/comment-1'             => [
		'title'  => 'comment',
		'symbol' => $svg_symbol . 'user-interface/comment-1',
		'path'   => $svg_path . 'user-interface/comment-1.svg',
		'url'    => $svg_url . 'user-interface/comment-1.svg#wpgb-icon',
	],
	'wpgb/user-interface/comment-2-glyph'       => [
		'title'  => 'comment glyph',
		'symbol' => $svg_symbol . 'user-interface/comment-2-glyph',
		'path'   => $svg_path . 'user-interface/comment-2-glyph.svg',
		'url'    => $svg_url . 'user-interface/comment-2-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/comment-2'             => [
		'title'  => 'comment',
		'symbol' => $svg_symbol . 'user-interface/comment-2',
		'path'   => $svg_path . 'user-interface/comment-2.svg',
		'url'    => $svg_url . 'user-interface/comment-2.svg#wpgb-icon',
	],
	'wpgb/user-interface/comment-3-glyph'       => [
		'title'  => 'comment glyph',
		'symbol' => $svg_symbol . 'user-interface/comment-3-glyph',
		'path'   => $svg_path . 'user-interface/comment-3-glyph.svg',
		'url'    => $svg_url . 'user-interface/comment-3-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/comment-3'             => [
		'title'  => 'comment',
		'symbol' => $svg_symbol . 'user-interface/comment-3',
		'path'   => $svg_path . 'user-interface/comment-3.svg',
		'url'    => $svg_url . 'user-interface/comment-3.svg#wpgb-icon',
	],
	'wpgb/user-interface/comment-4-glyph'       => [
		'title'  => 'comment glyph',
		'symbol' => $svg_symbol . 'user-interface/comment-4-glyph',
		'path'   => $svg_path . 'user-interface/comment-4-glyph.svg',
		'url'    => $svg_url . 'user-interface/comment-4-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/comment-4'             => [
		'title'  => 'comment',
		'symbol' => $svg_symbol . 'user-interface/comment-4',
		'path'   => $svg_path . 'user-interface/comment-4.svg',
		'url'    => $svg_url . 'user-interface/comment-4.svg#wpgb-icon',
	],
	'wpgb/user-interface/comment-5-glyph'       => [
		'title'  => 'comment glyph',
		'symbol' => $svg_symbol . 'user-interface/comment-5-glyph',
		'path'   => $svg_path . 'user-interface/comment-5-glyph.svg',
		'url'    => $svg_url . 'user-interface/comment-5-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/comment-5'             => [
		'title'  => 'comment',
		'symbol' => $svg_symbol . 'user-interface/comment-5',
		'path'   => $svg_path . 'user-interface/comment-5.svg',
		'url'    => $svg_url . 'user-interface/comment-5.svg#wpgb-icon',
	],
	'wpgb/user-interface/cross-circle-glyph'    => [
		'title'  => 'cross circle glyph',
		'symbol' => $svg_symbol . 'user-interface/cross-circle-glyph',
		'path'   => $svg_path . 'user-interface/cross-circle-glyph.svg',
		'url'    => $svg_url . 'user-interface/cross-circle-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/cross-circle'          => [
		'title'  => 'cross circle',
		'symbol' => $svg_symbol . 'user-interface/cross-circle',
		'path'   => $svg_path . 'user-interface/cross-circle.svg',
		'url'    => $svg_url . 'user-interface/cross-circle.svg#wpgb-icon',
	],
	'wpgb/user-interface/cross-outline'         => [
		'title'  => 'cross outline',
		'symbol' => $svg_symbol . 'user-interface/cross-outline',
		'path'   => $svg_path . 'user-interface/cross-outline.svg',
		'url'    => $svg_url . 'user-interface/cross-outline.svg#wpgb-icon',
	],
	'wpgb/user-interface/cross-square-glyph'    => [
		'title'  => 'cross square glyph',
		'symbol' => $svg_symbol . 'user-interface/cross-square-glyph',
		'path'   => $svg_path . 'user-interface/cross-square-glyph.svg',
		'url'    => $svg_url . 'user-interface/cross-square-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/cross-square'          => [
		'title'  => 'cross square',
		'symbol' => $svg_symbol . 'user-interface/cross-square',
		'path'   => $svg_path . 'user-interface/cross-square.svg',
		'url'    => $svg_url . 'user-interface/cross-square.svg#wpgb-icon',
	],
	'wpgb/user-interface/cross'                 => [
		'title'  => 'cross',
		'symbol' => $svg_symbol . 'user-interface/cross',
		'path'   => $svg_path . 'user-interface/cross.svg',
		'url'    => $svg_url . 'user-interface/cross.svg#wpgb-icon',
	],
	'wpgb/user-interface/curved-next-glyph'     => [
		'title'  => 'curved next glyph',
		'symbol' => $svg_symbol . 'user-interface/curved-next-glyph',
		'path'   => $svg_path . 'user-interface/curved-next-glyph.svg',
		'url'    => $svg_url . 'user-interface/curved-next-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/curved-next'           => [
		'title'  => 'curved next',
		'symbol' => $svg_symbol . 'user-interface/curved-next',
		'path'   => $svg_path . 'user-interface/curved-next.svg',
		'url'    => $svg_url . 'user-interface/curved-next.svg#wpgb-icon',
	],
	'wpgb/user-interface/curved-previous-glyph' => [
		'title'  => 'curved previous glyph',
		'symbol' => $svg_symbol . 'user-interface/curved-previous-glyph',
		'path'   => $svg_path . 'user-interface/curved-previous-glyph.svg',
		'url'    => $svg_url . 'user-interface/curved-previous-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/curved-previous'       => [
		'title'  => 'curved previous',
		'symbol' => $svg_symbol . 'user-interface/curved-previous',
		'path'   => $svg_path . 'user-interface/curved-previous.svg',
		'url'    => $svg_url . 'user-interface/curved-previous.svg#wpgb-icon',
	],
	'wpgb/user-interface/download-cloud'        => [
		'title'  => 'download cloud',
		'symbol' => $svg_symbol . 'user-interface/download-cloud',
		'path'   => $svg_path . 'user-interface/download-cloud.svg',
		'url'    => $svg_url . 'user-interface/download-cloud.svg#wpgb-icon',
	],
	'wpgb/user-interface/download-square'       => [
		'title'  => 'download square',
		'symbol' => $svg_symbol . 'user-interface/download-square',
		'path'   => $svg_path . 'user-interface/download-square.svg',
		'url'    => $svg_url . 'user-interface/download-square.svg#wpgb-icon',
	],
	'wpgb/user-interface/email'                 => [
		'title'  => 'email',
		'symbol' => $svg_symbol . 'user-interface/email',
		'path'   => $svg_path . 'user-interface/email.svg',
		'url'    => $svg_url . 'user-interface/email.svg#wpgb-icon',
	],
	'wpgb/user-interface/filter-1-glyph'        => [
		'title'  => 'filter glyph',
		'symbol' => $svg_symbol . 'user-interface/filter-1-glyph',
		'path'   => $svg_path . 'user-interface/filter-1-glyph.svg',
		'url'    => $svg_url . 'user-interface/filter-1-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/filter-1'              => [
		'title'  => 'filter',
		'symbol' => $svg_symbol . 'user-interface/filter-1',
		'path'   => $svg_path . 'user-interface/filter-1.svg',
		'url'    => $svg_url . 'user-interface/filter-1.svg#wpgb-icon',
	],
	'wpgb/user-interface/filter-2-glyph'        => [
		'title'  => 'filter glyph',
		'symbol' => $svg_symbol . 'user-interface/filter-2-glyph',
		'path'   => $svg_path . 'user-interface/filter-2-glyph.svg',
		'url'    => $svg_url . 'user-interface/filter-2-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/filter-2'              => [
		'title'  => 'filter',
		'symbol' => $svg_symbol . 'user-interface/filter-2',
		'path'   => $svg_path . 'user-interface/filter-2.svg',
		'url'    => $svg_url . 'user-interface/filter-2.svg#wpgb-icon',
	],
	'wpgb/user-interface/heart-add-glyph'       => [
		'title'  => 'heart add glyph',
		'symbol' => $svg_symbol . 'user-interface/heart-add-glyph',
		'path'   => $svg_path . 'user-interface/heart-add-glyph.svg',
		'url'    => $svg_url . 'user-interface/heart-add-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/heart-add'             => [
		'title'  => 'heart add',
		'symbol' => $svg_symbol . 'user-interface/heart-add',
		'path'   => $svg_path . 'user-interface/heart-add.svg',
		'url'    => $svg_url . 'user-interface/heart-add.svg#wpgb-icon',
	],
	'wpgb/user-interface/heart-glyph'           => [
		'title'  => 'heart glyph',
		'symbol' => $svg_symbol . 'user-interface/heart-glyph',
		'path'   => $svg_path . 'user-interface/heart-glyph.svg',
		'url'    => $svg_url . 'user-interface/heart-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/heart-remove-glyph'    => [
		'title'  => 'heart remove glyph',
		'symbol' => $svg_symbol . 'user-interface/heart-remove-glyph',
		'path'   => $svg_path . 'user-interface/heart-remove-glyph.svg',
		'url'    => $svg_url . 'user-interface/heart-remove-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/heart-remove'          => [
		'title'  => 'heart remove',
		'symbol' => $svg_symbol . 'user-interface/heart-remove',
		'path'   => $svg_path . 'user-interface/heart-remove.svg',
		'url'    => $svg_url . 'user-interface/heart-remove.svg#wpgb-icon',
	],
	'wpgb/user-interface/heart'                 => [
		'title'  => 'heart',
		'symbol' => $svg_symbol . 'user-interface/heart',
		'path'   => $svg_path . 'user-interface/heart.svg',
		'url'    => $svg_url . 'user-interface/heart.svg#wpgb-icon',
	],
	'wpgb/user-interface/link-1'                => [
		'title'  => 'link',
		'symbol' => $svg_symbol . 'user-interface/link-1',
		'path'   => $svg_path . 'user-interface/link-1.svg',
		'url'    => $svg_url . 'user-interface/link-1.svg#wpgb-icon',
	],
	'wpgb/user-interface/link-2'                => [
		'title'  => 'link',
		'symbol' => $svg_symbol . 'user-interface/link-2',
		'path'   => $svg_path . 'user-interface/link-2.svg',
		'url'    => $svg_url . 'user-interface/link-2.svg#wpgb-icon',
	],
	'wpgb/user-interface/link-3'                => [
		'title'  => 'link',
		'symbol' => $svg_symbol . 'user-interface/link-3',
		'path'   => $svg_path . 'user-interface/link-3.svg',
		'url'    => $svg_url . 'user-interface/link-3.svg#wpgb-icon',
	],
	'wpgb/user-interface/link-4'                => [
		'title'  => 'link',
		'symbol' => $svg_symbol . 'user-interface/link-4',
		'path'   => $svg_path . 'user-interface/link-4.svg',
		'url'    => $svg_url . 'user-interface/link-4.svg#wpgb-icon',
	],
	'wpgb/user-interface/link-5'                => [
		'title'  => 'link',
		'symbol' => $svg_symbol . 'user-interface/link-5',
		'path'   => $svg_path . 'user-interface/link-5.svg',
		'url'    => $svg_url . 'user-interface/link-5.svg#wpgb-icon',
	],
	'wpgb/user-interface/link-6'                => [
		'title'  => 'link',
		'symbol' => $svg_symbol . 'user-interface/link-6',
		'path'   => $svg_path . 'user-interface/link-6.svg',
		'url'    => $svg_url . 'user-interface/link-6.svg#wpgb-icon',
	],
	'wpgb/user-interface/link-7'                => [
		'title'  => 'link',
		'symbol' => $svg_symbol . 'user-interface/link-7',
		'path'   => $svg_path . 'user-interface/link-7.svg',
		'url'    => $svg_url . 'user-interface/link-7.svg#wpgb-icon',
	],
	'wpgb/user-interface/link-8'                => [
		'title'  => 'link',
		'symbol' => $svg_symbol . 'user-interface/link-8',
		'path'   => $svg_path . 'user-interface/link-8.svg',
		'url'    => $svg_url . 'user-interface/link-8.svg#wpgb-icon',
	],
	'wpgb/user-interface/padlock-close'         => [
		'title'  => 'padlock close',
		'symbol' => $svg_symbol . 'user-interface/padlock-close',
		'path'   => $svg_path . 'user-interface/padlock-close.svg',
		'url'    => $svg_url . 'user-interface/padlock-close.svg#wpgb-icon',
	],
	'wpgb/user-interface/padlock-glyph'         => [
		'title'  => 'padlock glyph',
		'symbol' => $svg_symbol . 'user-interface/padlock-glyph',
		'path'   => $svg_path . 'user-interface/padlock-glyph.svg',
		'url'    => $svg_url . 'user-interface/padlock-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/padlock-open-glyph'    => [
		'title'  => 'padlock open glyph',
		'symbol' => $svg_symbol . 'user-interface/padlock-open-glyph',
		'path'   => $svg_path . 'user-interface/padlock-open-glyph.svg',
		'url'    => $svg_url . 'user-interface/padlock-open-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/padlock-open'          => [
		'title'  => 'padlock open',
		'symbol' => $svg_symbol . 'user-interface/padlock-open',
		'path'   => $svg_path . 'user-interface/padlock-open.svg',
		'url'    => $svg_url . 'user-interface/padlock-open.svg#wpgb-icon',
	],
	'wpgb/user-interface/quote-1-glyph'         => [
		'title'  => 'quote glyph',
		'symbol' => $svg_symbol . 'user-interface/quote-1-glyph',
		'path'   => $svg_path . 'user-interface/quote-1-glyph.svg',
		'url'    => $svg_url . 'user-interface/quote-1-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/quote-2'               => [
		'title'  => 'quote',
		'symbol' => $svg_symbol . 'user-interface/quote-2',
		'path'   => $svg_path . 'user-interface/quote-2.svg',
		'url'    => $svg_url . 'user-interface/quote-2.svg#wpgb-icon',
	],
	'wpgb/user-interface/quote-3-glyph'         => [
		'title'  => 'quote glyph',
		'symbol' => $svg_symbol . 'user-interface/quote-3-glyph',
		'path'   => $svg_path . 'user-interface/quote-3-glyph.svg',
		'url'    => $svg_url . 'user-interface/quote-3-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/settings-glyph'        => [
		'title'  => 'settings glyph',
		'symbol' => $svg_symbol . 'user-interface/settings-glyph',
		'path'   => $svg_path . 'user-interface/settings-glyph.svg',
		'url'    => $svg_url . 'user-interface/settings-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/settings'              => [
		'title'  => 'settings',
		'symbol' => $svg_symbol . 'user-interface/settings',
		'path'   => $svg_path . 'user-interface/settings.svg',
		'url'    => $svg_url . 'user-interface/settings.svg#wpgb-icon',
	],
	'wpgb/user-interface/share-1-glyph'         => [
		'title'  => 'share glyph',
		'symbol' => $svg_symbol . 'user-interface/share-1-glyph',
		'path'   => $svg_path . 'user-interface/share-1-glyph.svg',
		'url'    => $svg_url . 'user-interface/share-1-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/share-1'               => [
		'title'  => 'share',
		'symbol' => $svg_symbol . 'user-interface/share-1',
		'path'   => $svg_path . 'user-interface/share-1.svg',
		'url'    => $svg_url . 'user-interface/share-1.svg#wpgb-icon',
	],
	'wpgb/user-interface/share-2'               => [
		'title'  => 'share',
		'symbol' => $svg_symbol . 'user-interface/share-2',
		'path'   => $svg_path . 'user-interface/share-2.svg',
		'url'    => $svg_url . 'user-interface/share-2.svg#wpgb-icon',
	],
	'wpgb/user-interface/share-3'               => [
		'title'  => 'share',
		'symbol' => $svg_symbol . 'user-interface/share-3',
		'path'   => $svg_path . 'user-interface/share-3.svg',
		'url'    => $svg_url . 'user-interface/share-3.svg#wpgb-icon',
	],
	'wpgb/user-interface/star-add-glyph'        => [
		'title'  => 'star add glyph',
		'symbol' => $svg_symbol . 'user-interface/star-add-glyph',
		'path'   => $svg_path . 'user-interface/star-add-glyph.svg',
		'url'    => $svg_url . 'user-interface/star-add-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/star-add'              => [
		'title'  => 'star add',
		'symbol' => $svg_symbol . 'user-interface/star-add',
		'path'   => $svg_path . 'user-interface/star-add.svg',
		'url'    => $svg_url . 'user-interface/star-add.svg#wpgb-icon',
	],
	'wpgb/user-interface/star-glyph'            => [
		'title'  => 'star glyph',
		'symbol' => $svg_symbol . 'user-interface/star-glyph',
		'path'   => $svg_path . 'user-interface/star-glyph.svg',
		'url'    => $svg_url . 'user-interface/star-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/star-remove-glyph'     => [
		'title'  => 'star remove glyph',
		'symbol' => $svg_symbol . 'user-interface/star-remove-glyph',
		'path'   => $svg_path . 'user-interface/star-remove-glyph.svg',
		'url'    => $svg_url . 'user-interface/star-remove-glyph.svg#wpgb-icon',
	],
	'wpgb/user-interface/star-remove'           => [
		'title'  => 'star remove',
		'symbol' => $svg_symbol . 'user-interface/star-remove',
		'path'   => $svg_path . 'user-interface/star-remove.svg',
		'url'    => $svg_url . 'user-interface/star-remove.svg#wpgb-icon',
	],
	'wpgb/user-interface/star'                  => [
		'title'  => 'star',
		'symbol' => $svg_symbol . 'user-interface/star',
		'path'   => $svg_path . 'user-interface/star.svg',
		'url'    => $svg_url . 'user-interface/star.svg#wpgb-icon',
	],
	'wpgb/user-interface/upload-cloud'          => [
		'title'  => 'upload cloud',
		'symbol' => $svg_symbol . 'user-interface/upload-cloud',
		'path'   => $svg_path . 'user-interface/upload-cloud.svg',
		'url'    => $svg_url . 'user-interface/upload-cloud.svg#wpgb-icon',
	],
	'wpgb/user-interface/zoom-1'                => [
		'title'  => 'zoom',
		'symbol' => $svg_symbol . 'user-interface/zoom-1',
		'path'   => $svg_path . 'user-interface/zoom-1.svg',
		'url'    => $svg_url . 'user-interface/zoom-1.svg#wpgb-icon',
	],
	'wpgb/user-interface/zoom-2'                => [
		'title'  => 'zoom',
		'symbol' => $svg_symbol . 'user-interface/zoom-2',
		'path'   => $svg_path . 'user-interface/zoom-2.svg',
		'url'    => $svg_url . 'user-interface/zoom-2.svg#wpgb-icon',
	],
	'wpgb/user-interface/zoom-3'                => [
		'title'  => 'zoom',
		'symbol' => $svg_symbol . 'user-interface/zoom-3',
		'path'   => $svg_path . 'user-interface/zoom-3.svg',
		'url'    => $svg_url . 'user-interface/zoom-3.svg#wpgb-icon',
	],
	'wpgb/user-interface/zoom-4'                => [
		'title'  => 'zoom',
		'symbol' => $svg_symbol . 'user-interface/zoom-4',
		'path'   => $svg_path . 'user-interface/zoom-4.svg',
		'url'    => $svg_url . 'user-interface/zoom-4.svg#wpgb-icon',
	],
	'wpgb/user-interface/zoom-in-1'             => [
		'title'  => 'zoom in',
		'symbol' => $svg_symbol . 'user-interface/zoom-in-1',
		'path'   => $svg_path . 'user-interface/zoom-in-1.svg',
		'url'    => $svg_url . 'user-interface/zoom-in-1.svg#wpgb-icon',
	],
	'wpgb/user-interface/zoom-in-2'             => [
		'title'  => 'zoom in',
		'symbol' => $svg_symbol . 'user-interface/zoom-in-2',
		'path'   => $svg_path . 'user-interface/zoom-in-2.svg',
		'url'    => $svg_url . 'user-interface/zoom-in-2.svg#wpgb-icon',
	],
	'wpgb/user-interface/zoom-in-3'             => [
		'title'  => 'zoom in',
		'symbol' => $svg_symbol . 'user-interface/zoom-in-3',
		'path'   => $svg_path . 'user-interface/zoom-in-3.svg',
		'url'    => $svg_url . 'user-interface/zoom-in-3.svg#wpgb-icon',
	],
	'wpgb/user-interface/zoom-in-4'             => [
		'title'  => 'zoom in',
		'symbol' => $svg_symbol . 'user-interface/zoom-in-4',
		'path'   => $svg_path . 'user-interface/zoom-in-4.svg',
		'url'    => $svg_url . 'user-interface/zoom-in-4.svg#wpgb-icon',
	],
	'wpgb/user-interface/zoom-out-1'            => [
		'title'  => 'zoom out',
		'symbol' => $svg_symbol . 'user-interface/zoom-out-1',
		'path'   => $svg_path . 'user-interface/zoom-out-1.svg',
		'url'    => $svg_url . 'user-interface/zoom-out-1.svg#wpgb-icon',
	],
	'wpgb/user-interface/zoom-out-2'            => [
		'title'  => 'zoom out',
		'symbol' => $svg_symbol . 'user-interface/zoom-out-2',
		'path'   => $svg_path . 'user-interface/zoom-out-2.svg',
		'url'    => $svg_url . 'user-interface/zoom-out-2.svg#wpgb-icon',
	],
	'wpgb/user-interface/zoom-out-3'            => [
		'title'  => 'zoom out',
		'symbol' => $svg_symbol . 'user-interface/zoom-out-3',
		'path'   => $svg_path . 'user-interface/zoom-out-3.svg',
		'url'    => $svg_url . 'user-interface/zoom-out-3.svg#wpgb-icon',
	],
	'wpgb/user-interface/zoom-out-4'            => [
		'title'  => 'zoom out',
		'symbol' => $svg_symbol . 'user-interface/zoom-out-4',
		'path'   => $svg_path . 'user-interface/zoom-out-4.svg',
		'url'    => $svg_url . 'user-interface/zoom-out-4.svg#wpgb-icon',
	],
	'wpgb/arrows/arrow-back'                    => [
		'title'  => 'arrow back',
		'symbol' => $svg_symbol . 'arrows/arrow-back',
		'path'   => $svg_path . 'arrows/arrow-back.svg',
		'url'    => $svg_url . 'arrows/arrow-back.svg#wpgb-icon',
	],
	'wpgb/arrows/arrow-down'                    => [
		'title'  => 'arrow down',
		'symbol' => $svg_symbol . 'arrows/arrow-down',
		'path'   => $svg_path . 'arrows/arrow-down.svg',
		'url'    => $svg_url . 'arrows/arrow-down.svg#wpgb-icon',
	],
	'wpgb/arrows/arrow-left'                    => [
		'title'  => 'arrow left',
		'symbol' => $svg_symbol . 'arrows/arrow-left',
		'path'   => $svg_path . 'arrows/arrow-left.svg',
		'url'    => $svg_url . 'arrows/arrow-left.svg#wpgb-icon',
	],
	'wpgb/arrows/arrow-loop'                    => [
		'title'  => 'arrow loop',
		'symbol' => $svg_symbol . 'arrows/arrow-loop',
		'path'   => $svg_path . 'arrows/arrow-loop.svg',
		'url'    => $svg_url . 'arrows/arrow-loop.svg#wpgb-icon',
	],
	'wpgb/arrows/arrow-right'                   => [
		'title'  => 'arrow right',
		'symbol' => $svg_symbol . 'arrows/arrow-right',
		'path'   => $svg_path . 'arrows/arrow-right.svg',
		'url'    => $svg_url . 'arrows/arrow-right.svg#wpgb-icon',
	],
	'wpgb/arrows/arrow-up'                      => [
		'title'  => 'arrow up',
		'symbol' => $svg_symbol . 'arrows/arrow-up',
		'path'   => $svg_path . 'arrows/arrow-up.svg',
		'url'    => $svg_url . 'arrows/arrow-up.svg#wpgb-icon',
	],
	'wpgb/arrows/enlarge-1'                     => [
		'title'  => 'enlarge',
		'symbol' => $svg_symbol . 'arrows/enlarge-1',
		'path'   => $svg_path . 'arrows/enlarge-1.svg',
		'url'    => $svg_url . 'arrows/enlarge-1.svg#wpgb-icon',
	],
	'wpgb/arrows/enlarge-2'                     => [
		'title'  => 'enlarge',
		'symbol' => $svg_symbol . 'arrows/enlarge-2',
		'path'   => $svg_path . 'arrows/enlarge-2.svg',
		'url'    => $svg_url . 'arrows/enlarge-2.svg#wpgb-icon',
	],
	'wpgb/arrows/enlarge-diagonal-1'            => [
		'title'  => 'enlarge diagonal',
		'symbol' => $svg_symbol . 'arrows/enlarge-diagonal-1',
		'path'   => $svg_path . 'arrows/enlarge-diagonal-1.svg',
		'url'    => $svg_url . 'arrows/enlarge-diagonal-1.svg#wpgb-icon',
	],
	'wpgb/arrows/enlarge-diagonal-2'            => [
		'title'  => 'enlarge diagonal',
		'symbol' => $svg_symbol . 'arrows/enlarge-diagonal-2',
		'path'   => $svg_path . 'arrows/enlarge-diagonal-2.svg',
		'url'    => $svg_url . 'arrows/enlarge-diagonal-2.svg#wpgb-icon',
	],
	'wpgb/arrows/enlarge-diagonal-3'            => [
		'title'  => 'enlarge diagonal',
		'symbol' => $svg_symbol . 'arrows/enlarge-diagonal-3',
		'path'   => $svg_path . 'arrows/enlarge-diagonal-3.svg',
		'url'    => $svg_url . 'arrows/enlarge-diagonal-3.svg#wpgb-icon',
	],
	'wpgb/arrows/enlarge-diagonal-4'            => [
		'title'  => 'enlarge diagonal',
		'symbol' => $svg_symbol . 'arrows/enlarge-diagonal-4',
		'path'   => $svg_path . 'arrows/enlarge-diagonal-4.svg',
		'url'    => $svg_url . 'arrows/enlarge-diagonal-4.svg#wpgb-icon',
	],
	'wpgb/arrows/tail-down'                     => [
		'title'  => 'tail down',
		'symbol' => $svg_symbol . 'arrows/tail-down',
		'path'   => $svg_path . 'arrows/tail-down.svg',
		'url'    => $svg_url . 'arrows/tail-down.svg#wpgb-icon',
	],
	'wpgb/arrows/tail-left'                     => [
		'title'  => 'tail left',
		'symbol' => $svg_symbol . 'arrows/tail-left',
		'path'   => $svg_path . 'arrows/tail-left.svg',
		'url'    => $svg_url . 'arrows/tail-left.svg#wpgb-icon',
	],
	'wpgb/arrows/tail-right'                    => [
		'title'  => 'tail right',
		'symbol' => $svg_symbol . 'arrows/tail-right',
		'path'   => $svg_path . 'arrows/tail-right.svg',
		'url'    => $svg_url . 'arrows/tail-right.svg#wpgb-icon',
	],
	'wpgb/arrows/tail-up'                       => [
		'title'  => 'tail up',
		'symbol' => $svg_symbol . 'arrows/tail-up',
		'path'   => $svg_path . 'arrows/tail-up.svg',
		'url'    => $svg_url . 'arrows/tail-up.svg#wpgb-icon',
	],
	'wpgb/emoticons/emoticon-puzzled'           => [
		'title'  => 'emoticon puzzled',
		'symbol' => $svg_symbol . 'emoticons/emoticon-puzzled',
		'path'   => $svg_path . 'emoticons/emoticon-puzzled.svg',
		'url'    => $svg_url . 'emoticons/emoticon-puzzled.svg#wpgb-icon',
	],
	'wpgb/emoticons/emoticon-sad'               => [
		'title'  => 'emoticon sad',
		'symbol' => $svg_symbol . 'emoticons/emoticon-sad',
		'path'   => $svg_path . 'emoticons/emoticon-sad.svg',
		'url'    => $svg_url . 'emoticons/emoticon-sad.svg#wpgb-icon',
	],
	'wpgb/emoticons/emoticon-smile'             => [
		'title'  => 'emoticon smile',
		'symbol' => $svg_symbol . 'emoticons/emoticon-smile',
		'path'   => $svg_path . 'emoticons/emoticon-smile.svg',
		'url'    => $svg_url . 'emoticons/emoticon-smile.svg#wpgb-icon',
	],
	'wpgb/emoticons/emoticon-speechless'        => [
		'title'  => 'emoticon speechless',
		'symbol' => $svg_symbol . 'emoticons/emoticon-speechless',
		'path'   => $svg_path . 'emoticons/emoticon-speechless.svg',
		'url'    => $svg_url . 'emoticons/emoticon-speechless.svg#wpgb-icon',
	],
	'wpgb/emoticons/finger-like-glyph'          => [
		'title'  => 'finger like glyph',
		'symbol' => $svg_symbol . 'emoticons/finger-like-glyph',
		'path'   => $svg_path . 'emoticons/finger-like-glyph.svg',
		'url'    => $svg_url . 'emoticons/finger-like-glyph.svg#wpgb-icon',
	],
	'wpgb/emoticons/finger-like'                => [
		'title'  => 'finger like',
		'symbol' => $svg_symbol . 'emoticons/finger-like',
		'path'   => $svg_path . 'emoticons/finger-like.svg',
		'url'    => $svg_url . 'emoticons/finger-like.svg#wpgb-icon',
	],
	'wpgb/emoticons/finger-unlike-glyph'        => [
		'title'  => 'finger unlike glyph',
		'symbol' => $svg_symbol . 'emoticons/finger-unlike-glyph',
		'path'   => $svg_path . 'emoticons/finger-unlike-glyph.svg',
		'url'    => $svg_url . 'emoticons/finger-unlike-glyph.svg#wpgb-icon',
	],
	'wpgb/emoticons/finger-unlike'              => [
		'title'  => 'finger unlike',
		'symbol' => $svg_symbol . 'emoticons/finger-unlike',
		'path'   => $svg_path . 'emoticons/finger-unlike.svg',
		'url'    => $svg_url . 'emoticons/finger-unlike.svg#wpgb-icon',
	],
	'wpgb/multimedia/action'                    => [
		'title'  => 'action',
		'symbol' => $svg_symbol . 'multimedia/action',
		'path'   => $svg_path . 'multimedia/action.svg',
		'url'    => $svg_url . 'multimedia/action.svg#wpgb-icon',
	],
	'wpgb/multimedia/audio-mic'                 => [
		'title'  => 'audio mic',
		'symbol' => $svg_symbol . 'multimedia/audio-mic',
		'path'   => $svg_path . 'multimedia/audio-mic.svg',
		'url'    => $svg_url . 'multimedia/audio-mic.svg#wpgb-icon',
	],
	'wpgb/multimedia/button-play-1-glyph'       => [
		'title'  => 'button play glyph',
		'symbol' => $svg_symbol . 'multimedia/button-play-1-glyph',
		'path'   => $svg_path . 'multimedia/button-play-1-glyph.svg',
		'url'    => $svg_url . 'multimedia/button-play-1-glyph.svg#wpgb-icon',
	],
	'wpgb/multimedia/button-play-1'             => [
		'title'  => 'button play',
		'symbol' => $svg_symbol . 'multimedia/button-play-1',
		'path'   => $svg_path . 'multimedia/button-play-1.svg',
		'url'    => $svg_url . 'multimedia/button-play-1.svg#wpgb-icon',
	],
	'wpgb/multimedia/button-play-2-glyph'       => [
		'title'  => 'button play glyph',
		'symbol' => $svg_symbol . 'multimedia/button-play-2-glyph',
		'path'   => $svg_path . 'multimedia/button-play-2-glyph.svg',
		'url'    => $svg_url . 'multimedia/button-play-2-glyph.svg#wpgb-icon',
	],
	'wpgb/multimedia/button-play-2'             => [
		'title'  => 'button play',
		'symbol' => $svg_symbol . 'multimedia/button-play-2',
		'path'   => $svg_path . 'multimedia/button-play-2.svg',
		'url'    => $svg_url . 'multimedia/button-play-2.svg#wpgb-icon',
	],
	'wpgb/multimedia/button-play-3-glyph'       => [
		'title'  => 'button play glyph',
		'symbol' => $svg_symbol . 'multimedia/button-play-3-glyph',
		'path'   => $svg_path . 'multimedia/button-play-3-glyph.svg',
		'url'    => $svg_url . 'multimedia/button-play-3-glyph.svg#wpgb-icon',
	],
	'wpgb/multimedia/button-play-3'             => [
		'title'  => 'button play',
		'symbol' => $svg_symbol . 'multimedia/button-play-3',
		'path'   => $svg_path . 'multimedia/button-play-3.svg',
		'url'    => $svg_url . 'multimedia/button-play-3.svg#wpgb-icon',
	],
	'wpgb/multimedia/camera'                    => [
		'title'  => 'camera',
		'symbol' => $svg_symbol . 'multimedia/camera',
		'path'   => $svg_path . 'multimedia/camera.svg',
		'url'    => $svg_url . 'multimedia/camera.svg#wpgb-icon',
	],
	'wpgb/maps/bookmark'                        => [
		'title'  => 'bookmark',
		'symbol' => $svg_symbol . 'maps/bookmark',
		'path'   => $svg_path . 'maps/bookmark.svg',
		'url'    => $svg_url . 'maps/bookmark.svg#wpgb-icon',
	],
	'wpgb/maps/compass'                         => [
		'title'  => 'compass',
		'symbol' => $svg_symbol . 'maps/compass',
		'path'   => $svg_path . 'maps/compass.svg',
		'url'    => $svg_url . 'maps/compass.svg#wpgb-icon',
	],
	'wpgb/maps/flag-points'                     => [
		'title'  => 'flag points',
		'symbol' => $svg_symbol . 'maps/flag-points',
		'path'   => $svg_path . 'maps/flag-points.svg',
		'url'    => $svg_url . 'maps/flag-points.svg#wpgb-icon',
	],
	'wpgb/maps/flag'                            => [
		'title'  => 'flag',
		'symbol' => $svg_symbol . 'maps/flag',
		'path'   => $svg_path . 'maps/flag.svg',
		'url'    => $svg_url . 'maps/flag.svg#wpgb-icon',
	],
	'wpgb/maps/gps'                             => [
		'title'  => 'gps',
		'symbol' => $svg_symbol . 'maps/gps',
		'path'   => $svg_path . 'maps/gps.svg',
		'url'    => $svg_url . 'maps/gps.svg#wpgb-icon',
	],
	'wpgb/maps/map'                             => [
		'title'  => 'map',
		'symbol' => $svg_symbol . 'maps/map',
		'path'   => $svg_path . 'maps/map.svg',
		'url'    => $svg_url . 'maps/map.svg#wpgb-icon',
	],
	'wpgb/maps/marker'                          => [
		'title'  => 'marker',
		'symbol' => $svg_symbol . 'maps/marker',
		'path'   => $svg_path . 'maps/marker.svg',
		'url'    => $svg_url . 'maps/marker.svg#wpgb-icon',
	],
	'wpgb/maps/pin'                             => [
		'title'  => 'pin',
		'symbol' => $svg_symbol . 'maps/pin',
		'path'   => $svg_path . 'maps/pin.svg',
		'url'    => $svg_url . 'maps/pin.svg#wpgb-icon',
	],
	'wpgb/home/air-conditioner'                 => [
		'title'  => 'air conditioner',
		'symbol' => $svg_symbol . 'home/air-conditioner',
		'path'   => $svg_path . 'home/air-conditioner.svg',
		'url'    => $svg_url . 'home/air-conditioner.svg#wpgb-icon',
	],
	'wpgb/home/apartment'                       => [
		'title'  => 'apartment',
		'symbol' => $svg_symbol . 'home/apartment',
		'path'   => $svg_path . 'home/apartment.svg',
		'url'    => $svg_url . 'home/apartment.svg#wpgb-icon',
	],
	'wpgb/home/armchair'                        => [
		'title'  => 'armchair',
		'symbol' => $svg_symbol . 'home/armchair',
		'path'   => $svg_path . 'home/armchair.svg',
		'url'    => $svg_url . 'home/armchair.svg#wpgb-icon',
	],
	'wpgb/home/bath-tub'                        => [
		'title'  => 'bath tub',
		'symbol' => $svg_symbol . 'home/bath-tub',
		'path'   => $svg_path . 'home/bath-tub.svg',
		'url'    => $svg_url . 'home/bath-tub.svg#wpgb-icon',
	],
	'wpgb/home/bed-2'                           => [
		'title'  => 'bed',
		'symbol' => $svg_symbol . 'home/bed-2',
		'path'   => $svg_path . 'home/bed-2.svg',
		'url'    => $svg_url . 'home/bed-2.svg#wpgb-icon',
	],
	'wpgb/home/bed-side'                        => [
		'title'  => 'bed side',
		'symbol' => $svg_symbol . 'home/bed-side',
		'path'   => $svg_path . 'home/bed-side.svg',
		'url'    => $svg_url . 'home/bed-side.svg#wpgb-icon',
	],
	'wpgb/home/bed'                             => [
		'title'  => 'bed',
		'symbol' => $svg_symbol . 'home/bed',
		'path'   => $svg_path . 'home/bed.svg',
		'url'    => $svg_url . 'home/bed.svg#wpgb-icon',
	],
	'wpgb/home/bedroom'                         => [
		'title'  => 'bedroom',
		'symbol' => $svg_symbol . 'home/bedroom',
		'path'   => $svg_path . 'home/bedroom.svg',
		'url'    => $svg_url . 'home/bedroom.svg#wpgb-icon',
	],
	'wpgb/home/books'                           => [
		'title'  => 'books',
		'symbol' => $svg_symbol . 'home/books',
		'path'   => $svg_path . 'home/books.svg',
		'url'    => $svg_url . 'home/books.svg#wpgb-icon',
	],
	'wpgb/home/broom'                           => [
		'title'  => 'broom',
		'symbol' => $svg_symbol . 'home/broom',
		'path'   => $svg_path . 'home/broom.svg',
		'url'    => $svg_url . 'home/broom.svg#wpgb-icon',
	],
	'wpgb/home/cabinet'                         => [
		'title'  => 'cabinet',
		'symbol' => $svg_symbol . 'home/cabinet',
		'path'   => $svg_path . 'home/cabinet.svg',
		'url'    => $svg_url . 'home/cabinet.svg#wpgb-icon',
	],
	'wpgb/home/cactus'                          => [
		'title'  => 'cactus',
		'symbol' => $svg_symbol . 'home/cactus',
		'path'   => $svg_path . 'home/cactus.svg',
		'url'    => $svg_url . 'home/cactus.svg#wpgb-icon',
	],
	'wpgb/home/chair-2'                         => [
		'title'  => 'chair',
		'symbol' => $svg_symbol . 'home/chair-2',
		'path'   => $svg_path . 'home/chair-2.svg',
		'url'    => $svg_url . 'home/chair-2.svg#wpgb-icon',
	],
	'wpgb/home/chair'                           => [
		'title'  => 'chair',
		'symbol' => $svg_symbol . 'home/chair',
		'path'   => $svg_path . 'home/chair.svg',
		'url'    => $svg_url . 'home/chair.svg#wpgb-icon',
	],
	'wpgb/home/coat-hanger'                     => [
		'title'  => 'coat hanger',
		'symbol' => $svg_symbol . 'home/coat-hanger',
		'path'   => $svg_path . 'home/coat-hanger.svg',
		'url'    => $svg_url . 'home/coat-hanger.svg#wpgb-icon',
	],
	'wpgb/home/coffee'                          => [
		'title'  => 'coffee',
		'symbol' => $svg_symbol . 'home/coffee',
		'path'   => $svg_path . 'home/coffee.svg',
		'url'    => $svg_url . 'home/coffee.svg#wpgb-icon',
	],
	'wpgb/home/cradle'                          => [
		'title'  => 'cradle',
		'symbol' => $svg_symbol . 'home/cradle',
		'path'   => $svg_path . 'home/cradle.svg',
		'url'    => $svg_url . 'home/cradle.svg#wpgb-icon',
	],
	'wpgb/home/crane'                           => [
		'title'  => 'crane',
		'symbol' => $svg_symbol . 'home/crane',
		'path'   => $svg_path . 'home/crane.svg',
		'url'    => $svg_url . 'home/crane.svg#wpgb-icon',
	],
	'wpgb/home/curtains'                        => [
		'title'  => 'curtains',
		'symbol' => $svg_symbol . 'home/curtains',
		'path'   => $svg_path . 'home/curtains.svg',
		'url'    => $svg_url . 'home/curtains.svg#wpgb-icon',
	],
	'wpgb/home/desk-drawer'                     => [
		'title'  => 'desk drawer',
		'symbol' => $svg_symbol . 'home/desk-drawer',
		'path'   => $svg_path . 'home/desk-drawer.svg',
		'url'    => $svg_url . 'home/desk-drawer.svg#wpgb-icon',
	],
	'wpgb/home/desk'                            => [
		'title'  => 'desk',
		'symbol' => $svg_symbol . 'home/desk',
		'path'   => $svg_path . 'home/desk.svg',
		'url'    => $svg_url . 'home/desk.svg#wpgb-icon',
	],
	'wpgb/home/detached-property'               => [
		'title'  => 'detached property',
		'symbol' => $svg_symbol . 'home/detached-property',
		'path'   => $svg_path . 'home/detached-property.svg',
		'url'    => $svg_url . 'home/detached-property.svg#wpgb-icon',
	],
	'wpgb/home/door'                            => [
		'title'  => 'door',
		'symbol' => $svg_symbol . 'home/door',
		'path'   => $svg_path . 'home/door.svg',
		'url'    => $svg_url . 'home/door.svg#wpgb-icon',
	],
	'wpgb/home/drawer-2'                        => [
		'title'  => 'drawer',
		'symbol' => $svg_symbol . 'home/drawer-2',
		'path'   => $svg_path . 'home/drawer-2.svg',
		'url'    => $svg_url . 'home/drawer-2.svg#wpgb-icon',
	],
	'wpgb/home/drawer'                          => [
		'title'  => 'drawer',
		'symbol' => $svg_symbol . 'home/drawer',
		'path'   => $svg_path . 'home/drawer.svg',
		'url'    => $svg_url . 'home/drawer.svg#wpgb-icon',
	],
	'wpgb/home/escalator'                       => [
		'title'  => 'escalator',
		'symbol' => $svg_symbol . 'home/escalator',
		'path'   => $svg_path . 'home/escalator.svg',
		'url'    => $svg_url . 'home/escalator.svg#wpgb-icon',
	],
	'wpgb/home/fridge'                          => [
		'title'  => 'fridge',
		'symbol' => $svg_symbol . 'home/fridge',
		'path'   => $svg_path . 'home/fridge.svg',
		'url'    => $svg_url . 'home/fridge.svg#wpgb-icon',
	],
	'wpgb/home/furnished-property'              => [
		'title'  => 'furnished property',
		'symbol' => $svg_symbol . 'home/furnished-property',
		'path'   => $svg_path . 'home/furnished-property.svg',
		'url'    => $svg_url . 'home/furnished-property.svg#wpgb-icon',
	],
	'wpgb/home/gym'                             => [
		'title'  => 'gym',
		'symbol' => $svg_symbol . 'home/gym',
		'path'   => $svg_path . 'home/gym.svg',
		'url'    => $svg_url . 'home/gym.svg#wpgb-icon',
	],
	'wpgb/home/hanger-clothes'                  => [
		'title'  => 'hanger clothes',
		'symbol' => $svg_symbol . 'home/hanger-clothes',
		'path'   => $svg_path . 'home/hanger-clothes.svg',
		'url'    => $svg_url . 'home/hanger-clothes.svg#wpgb-icon',
	],
	'wpgb/home/hanger'                          => [
		'title'  => 'hanger',
		'symbol' => $svg_symbol . 'home/hanger',
		'path'   => $svg_path . 'home/hanger.svg',
		'url'    => $svg_url . 'home/hanger.svg#wpgb-icon',
	],
	'wpgb/home/heater'                          => [
		'title'  => 'heater',
		'symbol' => $svg_symbol . 'home/heater',
		'path'   => $svg_path . 'home/heater.svg',
		'url'    => $svg_url . 'home/heater.svg#wpgb-icon',
	],
	'wpgb/home/iron'                            => [
		'title'  => 'iron',
		'symbol' => $svg_symbol . 'home/iron',
		'path'   => $svg_path . 'home/iron.svg',
		'url'    => $svg_url . 'home/iron.svg#wpgb-icon',
	],
	'wpgb/home/lamp-2'                          => [
		'title'  => 'lamp',
		'symbol' => $svg_symbol . 'home/lamp-2',
		'path'   => $svg_path . 'home/lamp-2.svg',
		'url'    => $svg_url . 'home/lamp-2.svg#wpgb-icon',
	],
	'wpgb/home/lamp-floor'                      => [
		'title'  => 'lamp floor',
		'symbol' => $svg_symbol . 'home/lamp-floor',
		'path'   => $svg_path . 'home/lamp-floor.svg',
		'url'    => $svg_url . 'home/lamp-floor.svg#wpgb-icon',
	],
	'wpgb/home/lamp'                            => [
		'title'  => 'lamp',
		'symbol' => $svg_symbol . 'home/lamp',
		'path'   => $svg_path . 'home/lamp.svg',
		'url'    => $svg_url . 'home/lamp.svg#wpgb-icon',
	],
	'wpgb/home/library'                         => [
		'title'  => 'library',
		'symbol' => $svg_symbol . 'home/library',
		'path'   => $svg_path . 'home/library.svg',
		'url'    => $svg_url . 'home/library.svg#wpgb-icon',
	],
	'wpgb/home/lift'                            => [
		'title'  => 'lift',
		'symbol' => $svg_symbol . 'home/lift',
		'path'   => $svg_path . 'home/lift.svg',
		'url'    => $svg_url . 'home/lift.svg#wpgb-icon',
	],
	'wpgb/home/light-2'                         => [
		'title'  => 'light',
		'symbol' => $svg_symbol . 'home/light-2',
		'path'   => $svg_path . 'home/light-2.svg',
		'url'    => $svg_url . 'home/light-2.svg#wpgb-icon',
	],
	'wpgb/home/light'                           => [
		'title'  => 'light',
		'symbol' => $svg_symbol . 'home/light',
		'path'   => $svg_path . 'home/light.svg',
		'url'    => $svg_url . 'home/light.svg#wpgb-icon',
	],
	'wpgb/home/mixer'                           => [
		'title'  => 'mixer',
		'symbol' => $svg_symbol . 'home/mixer',
		'path'   => $svg_path . 'home/mixer.svg',
		'url'    => $svg_url . 'home/mixer.svg#wpgb-icon',
	],
	'wpgb/home/new-construction'                => [
		'title'  => 'new construction',
		'symbol' => $svg_symbol . 'home/new-construction',
		'path'   => $svg_path . 'home/new-construction.svg',
		'url'    => $svg_url . 'home/new-construction.svg#wpgb-icon',
	],
	'wpgb/home/oven'                            => [
		'title'  => 'oven',
		'symbol' => $svg_symbol . 'home/oven',
		'path'   => $svg_path . 'home/oven.svg',
		'url'    => $svg_url . 'home/oven.svg#wpgb-icon',
	],
	'wpgb/home/photo-frame'                     => [
		'title'  => 'photo frame',
		'symbol' => $svg_symbol . 'home/photo-frame',
		'path'   => $svg_path . 'home/photo-frame.svg',
		'url'    => $svg_url . 'home/photo-frame.svg#wpgb-icon',
	],
	'wpgb/home/safe'                            => [
		'title'  => 'safe',
		'symbol' => $svg_symbol . 'home/safe',
		'path'   => $svg_path . 'home/safe.svg',
		'url'    => $svg_url . 'home/safe.svg#wpgb-icon',
	],
	'wpgb/home/shower'                          => [
		'title'  => 'shower',
		'symbol' => $svg_symbol . 'home/shower',
		'path'   => $svg_path . 'home/shower.svg',
		'url'    => $svg_url . 'home/shower.svg#wpgb-icon',
	],
	'wpgb/home/sink-wash'                       => [
		'title'  => 'sink wash',
		'symbol' => $svg_symbol . 'home/sink-wash',
		'path'   => $svg_path . 'home/sink-wash.svg',
		'url'    => $svg_url . 'home/sink-wash.svg#wpgb-icon',
	],
	'wpgb/home/sink'                            => [
		'title'  => 'sink',
		'symbol' => $svg_symbol . 'home/sink',
		'path'   => $svg_path . 'home/sink.svg',
		'url'    => $svg_url . 'home/sink.svg#wpgb-icon',
	],
	'wpgb/home/smart-house'                     => [
		'title'  => 'smart house',
		'symbol' => $svg_symbol . 'home/smart-house',
		'path'   => $svg_path . 'home/smart-house.svg',
		'url'    => $svg_url . 'home/smart-house.svg#wpgb-icon',
	],
	'wpgb/home/sofa'                            => [
		'title'  => 'sofa',
		'symbol' => $svg_symbol . 'home/sofa',
		'path'   => $svg_path . 'home/sofa.svg',
		'url'    => $svg_url . 'home/sofa.svg#wpgb-icon',
	],
	'wpgb/home/spray'                           => [
		'title'  => 'spray',
		'symbol' => $svg_symbol . 'home/spray',
		'path'   => $svg_path . 'home/spray.svg',
		'url'    => $svg_url . 'home/spray.svg#wpgb-icon',
	],
	'wpgb/home/stairs'                          => [
		'title'  => 'stairs',
		'symbol' => $svg_symbol . 'home/stairs',
		'path'   => $svg_path . 'home/stairs.svg',
		'url'    => $svg_url . 'home/stairs.svg#wpgb-icon',
	],
	'wpgb/home/storage-hanger'                  => [
		'title'  => 'storage hanger',
		'symbol' => $svg_symbol . 'home/storage-hanger',
		'path'   => $svg_path . 'home/storage-hanger.svg',
		'url'    => $svg_url . 'home/storage-hanger.svg#wpgb-icon',
	],
	'wpgb/home/storage'                         => [
		'title'  => 'storage',
		'symbol' => $svg_symbol . 'home/storage',
		'path'   => $svg_path . 'home/storage.svg',
		'url'    => $svg_url . 'home/storage.svg#wpgb-icon',
	],
	'wpgb/home/switcher'                        => [
		'title'  => 'switcher',
		'symbol' => $svg_symbol . 'home/switcher',
		'path'   => $svg_path . 'home/switcher.svg',
		'url'    => $svg_url . 'home/switcher.svg#wpgb-icon',
	],
	'wpgb/home/table'                           => [
		'title'  => 'table',
		'symbol' => $svg_symbol . 'home/table',
		'path'   => $svg_path . 'home/table.svg',
		'url'    => $svg_url . 'home/table.svg#wpgb-icon',
	],
	'wpgb/home/telephone'                       => [
		'title'  => 'telephone',
		'symbol' => $svg_symbol . 'home/telephone',
		'path'   => $svg_path . 'home/telephone.svg',
		'url'    => $svg_url . 'home/telephone.svg#wpgb-icon',
	],
	'wpgb/home/terrace'                         => [
		'title'  => 'terrace',
		'symbol' => $svg_symbol . 'home/terrace',
		'path'   => $svg_path . 'home/terrace.svg',
		'url'    => $svg_url . 'home/terrace.svg#wpgb-icon',
	],
	'wpgb/home/time-alarm'                      => [
		'title'  => 'time alarm',
		'symbol' => $svg_symbol . 'home/time-alarm',
		'path'   => $svg_path . 'home/time-alarm.svg',
		'url'    => $svg_url . 'home/time-alarm.svg#wpgb-icon',
	],
	'wpgb/home/time-clock'                      => [
		'title'  => 'time clock',
		'symbol' => $svg_symbol . 'home/time-clock',
		'path'   => $svg_path . 'home/time-clock.svg',
		'url'    => $svg_url . 'home/time-clock.svg#wpgb-icon',
	],
	'wpgb/home/toilet-paper'                    => [
		'title'  => 'toilet paper',
		'symbol' => $svg_symbol . 'home/toilet-paper',
		'path'   => $svg_path . 'home/toilet-paper.svg',
		'url'    => $svg_url . 'home/toilet-paper.svg#wpgb-icon',
	],
	'wpgb/home/toilet'                          => [
		'title'  => 'toilet',
		'symbol' => $svg_symbol . 'home/toilet',
		'path'   => $svg_path . 'home/toilet.svg',
		'url'    => $svg_url . 'home/toilet.svg#wpgb-icon',
	],
	'wpgb/home/trash'                           => [
		'title'  => 'trash',
		'symbol' => $svg_symbol . 'home/trash',
		'path'   => $svg_path . 'home/trash.svg',
		'url'    => $svg_url . 'home/trash.svg#wpgb-icon',
	],
	'wpgb/home/tv-stand'                        => [
		'title'  => 'tv stand',
		'symbol' => $svg_symbol . 'home/tv-stand',
		'path'   => $svg_path . 'home/tv-stand.svg',
		'url'    => $svg_url . 'home/tv-stand.svg#wpgb-icon',
	],
	'wpgb/home/wardrobe'                        => [
		'title'  => 'wardrobe',
		'symbol' => $svg_symbol . 'home/wardrobe',
		'path'   => $svg_path . 'home/wardrobe.svg',
		'url'    => $svg_url . 'home/wardrobe.svg#wpgb-icon',
	],
	'wpgb/home/wash-2'                          => [
		'title'  => 'wash',
		'symbol' => $svg_symbol . 'home/wash-2',
		'path'   => $svg_path . 'home/wash-2.svg',
		'url'    => $svg_url . 'home/wash-2.svg#wpgb-icon',
	],
	'wpgb/home/wash'                            => [
		'title'  => 'wash',
		'symbol' => $svg_symbol . 'home/wash',
		'path'   => $svg_path . 'home/wash.svg',
		'url'    => $svg_url . 'home/wash.svg#wpgb-icon',
	],
	'wpgb/home/weight-scale'                    => [
		'title'  => 'weight scale',
		'symbol' => $svg_symbol . 'home/weight-scale',
		'path'   => $svg_path . 'home/weight-scale.svg',
		'url'    => $svg_url . 'home/weight-scale.svg#wpgb-icon',
	],
];
