/*!
* WP Grid Builder
*
* @package   WP Grid Builder
* @author    Loïc Blascos
* @link      https://www.wpgridbuilder.com
* @copyright 2019-2024 Loïc Blascos
*
*/
(()=>{"use strict";const t={selector:".wpgb-lightbox",draggingClass:"wpgb-is-dragging",relAttr:"data-rel",nextLabel:"Next slide",prevLabel:"Previous slide",closeLabel:"Close lightbox",arrowShape:"M18,12 L10,20 L18,28 M10,20 L30,20",closeShape:"M10,10 L30,30 M30,10 L10,30",counterMsg:"[index] / [total]",errorMsg:"Sorry, an error occured while loading the content...",rightToLeft:!1};class e{constructor(){this.listeners=new Map}canListen(t,e){return!("function"!=typeof e||!t)||(!("object"!=typeof e||!e[t])||(console.error(`Invalid listener for event name: "${t}"`),!1))}exists(t,e){if(this.listeners.has(t))return this.listeners.get(t).find((t=>t.listener===e))}on(t,e){let i=arguments.length>2&&void 0!==arguments[2]&&arguments[2];return this.canListen(t,e)?(this.listeners.has(t)||this.listeners.set(t,[]),this.exists(t,e)||this.listeners.get(t).push({listener:e,once:i}),this):this}once(t,e){return this.on(t,e,!0)}off(t,e){const i=this.listeners.get(t)||[],s=i.findIndex((t=>t.listener===e));return s>-1&&i.splice(s,1),i.length<1&&this.listeners.delete(t),this}offAll(){return this.listeners.clear(),this}emit(t){for(var e=arguments.length,i=new Array(e>1?e-1:0),s=1;s<e;s++)i[s-1]=arguments[s];return[...this.listeners.get(t)||[]].forEach((e=>{e.once&&this.off(t,e.listener),"object"==typeof e.listener?e.listener[t].apply(e.listener,...i):e.listener.apply(this,...i)})),this}}let i=!1;try{let t=Object.defineProperty({},"passive",{get:()=>i=!0});window.addEventListener("test",null,t),window.removeEventListener("test",null,t)}catch(t){}class s extends e{attachPointers(t){this.pointer={},this.pointedElement=t,this.passiveListener=i,this._getEvents(),this._unifyEvents(),this._bindEvents()}_getEvents(){this.events={down:"mousedown",move:"mousemove",up:"mouseup"},window.PointerEvent?this.events={down:"pointerdown",move:"pointermove",up:"pointerup",cancel:"pointercancel"}:"ontouchstart"in window&&(this.events={down:"touchstart",move:"touchmove",up:"touchend",cancel:"touchcancel"})}_unifyEvents(){for(let t in this.events)this[`on${this.events[t]}`]=this._handleEvent}_bindEvents(){let t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];t=t?"add":"remove",(arguments.length>0&&void 0!==arguments[0]?arguments[0]:["down"]).forEach((e=>{("down"===e?this.pointedElement:window)[`${t}EventListener`](this.events[e],this,!!this.passiveListener&&{passive:!1})}))}handleEvent(t){const e="on"+t.type;this[e]&&this[e](t)}_handleEvent(t){if(this.isPointer(t)&&this.hasPointer(t))for(let e in this.events)if(this.events[e]===t.type)return this[`_pointer${e}`](t)}isPointer(t){return!t.button||t.button<1}hasPointer(t){const e=t.changedTouches||[t];for(let t=0;t<e.length;t++){let i=e[t].pointerId||e[t].identifier,s=this.pointer.pointerId||this.pointer.identifier;if(i===s||void 0===s)return this.pointer=e[t],!0}return!1}_pointerdown(t){this._bindEvents(["move","up","cancel"]),this._callBack("pointerDown",t)}_pointermove(t){this._callBack("pointerMove",t)}_pointerup(t){this._callBack("pointerUp",t),this._pointerDone(t)}_pointercancel(t){this._callBack("pointerCancel",t),this._pointerDone(t)}_pointerDone(t){this._callBack("pointerDone",t),this._pointerReset()}_pointerReset(){this._bindEvents(["move","up","cancel"],!1),this.pointer={}}_callBack(t,e,i){this[t]?this[t](e,this.pointer,i):this.emit(t,[e,this.pointer,i])}}const n={nodes:["TEXTAREA","SELECT","OPTION","INPUT"],types:["checkbox","radio","button","submit","image","file"]};class r extends s{drag(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{x:3,y:3},i=arguments.length>2&&void 0!==arguments[2]&&arguments[2];this.threshold=e,this.attachPointers(t),t.addEventListener("click",this),i&&window.addEventListener("touchmove",this.preventScrolling.bind(this),!!this.passiveListener&&{passive:!1})}canDragTarget(t){let{target:{nodeName:e,type:i}}=t;return!(n.nodes.includes(e)||n.types.includes(i))}canDragStart(t,e){const{x:i,y:s}=this.threshold,n=180*Math.atan2(Math.abs(e),Math.abs(t))/Math.PI,r=Math.sqrt(t**2+e**2);return!1!==i&&r>i&&n<=45||!1!==s&&r>s&&n>=45}canPreventDefault(t){let{type:e,pointerType:i}=t;return"touchstart"!==e&&"touch"!==i}getPointerVector(t){return{x:t.pageX-this.pointerStart.x,y:t.pageY-this.pointerStart.y}}pointerDown(t,e){this.preventClick=!1,this.canDragTarget(t)?(this.pointerStart={x:e.pageX,y:e.pageY},this.canPreventDefault(t)&&t.preventDefault(),this._callBack("dragDown",t)):this._pointerReset()}pointerMove(t,e){const{x:i,y:s}=this.getPointerVector(e);this.dragging?(t.preventDefault(),this._callBack("dragMove",t,{x:i,y:s})):this.canDragStart(i,s)&&(this.pointerStart.x+=i,this.pointerStart.y+=s,this.preventClick=!0,this.dragging=!0,this._callBack("dragStart",t,this.getPointerVector(e)))}pointerUp(t,e){this.dragging&&this._callBack("dragEnd",t,this.getPointerVector(e))}pointerCancel(t,e){this.dragging&&this._callBack("dragCancel",t,this.getPointerVector(e))}pointerDone(t,e){this._callBack("dragUp",t,this.getPointerVector(e)),this.dragging&&(this.dragging=!1,this._callBack("dragDone",t,this.getPointerVector(e)))}onclick(t){this.preventClick&&t.preventDefault()}preventScrolling(t){this.dragging&&t.preventDefault()}}class o extends r{dragger(){this.drag(this.markup.holder,{x:3,y:3},!0)}dragStart(t,e,i){this.markup.holder.classList.add(this.options.draggingClass),this.emit("dragStart",[t])}dragMove(t,e,i){if(this.items.length<2)return;const{x:s,y:n}=i,{style:r}=this.markup.figure;r.transition="",r.transform=`translate3d(${s/4}px,0,0)`,this.emit("dragMove",[t,i])}dragUp(t,e,i){const{x:s,y:n}=i,{rightToLeft:r}=this.options;this.dragging&&this.emit("dragEnd",[t]),Math.abs(s)<50||Math.abs(s)>Math.abs(n)&&this[(r?-1:1)*s>0?"previous":"next"]()}dragDone(t,e,i){const{style:s}=this.markup.figure;s.transition="transform 0.3s ease",s.transform="translate3d(0,0,0)",this.markup.holder.classList.remove(this.options.draggingClass)}dragDown(){}dragEnd(){}dragCancel(){}}class a extends o{bindEvents(){let t=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];t=t?"addEventListener":"removeEventListener",window[t]("keydown",this),window[t]("resize",this),window[t]("orientationchange",this),this.markup.holder[t]("transitionend",this)}onclick(t){const e=t.target,{holder:i,close:s,prev:n,next:r}=this.markup;this.preventClick?t.preventDefault():e===n?this.previous():e===r?this.next():e!==s&&e!==i||this.close()}onkeydown(t){const{keyCode:e}=t,{rightToLeft:i}=this.options;37===e||38===e?(t.preventDefault(),this[i?"next":"previous"]()):39===e||40===e?(t.preventDefault(),this[i?"previous":"next"]()):27===e&&this.close()}onresize(t){this.resize()}onorientationchange(t){this.resize()}ontransitionend(t){if(t.target!==this.markup.holder||"visibility"!==t.propertyName)return;"hidden"===window.getComputedStyle(t.target).getPropertyValue("visibility")&&(this.bindEvents(!1),this.toggle(!1),this.remove())}}class h extends a{constructor(){super(),this.markup={},this.nodes={holder:"div",figure:"figure",caption:"figcaption",title:"div",desc:"div",counter:"div",close:"button",prev:"button",next:"button"}}create(){this.createElements(),this.createButtons(),this.createMarkup()}append(){if(this.markup.holder&&this.markup.holder.parentElement)return void this.removeMedia();const t=document.createComment(" Gridbuilder ᵂᴾ - Lightbox ");document.body.appendChild(t),document.body.appendChild(this.markup.holder)}remove(){this.markup.holder&&this.markup.holder.parentElement&&(this.removeMedia(),this.markup.holder.parentElement.removeChild(this.markup.holder.previousSibling),this.markup.holder.parentElement.removeChild(this.markup.holder))}removeMedia(){const{figure:{firstElementChild:t}}=this.markup;"FIGCAPTION"!==t.tagName&&this.markup.figure.removeChild(t)}createElements(){for(let t in this.nodes)this.markup[t]=document.createElement(this.nodes[t]),this.markup[t].className=`wpgb-lightbox-${t}`;this.markup.holder.tabIndex=-1,this.markup.holder.setAttribute("aria-hidden","true"),this.markup.holder.setAttribute("role","dialog"),this.markup.holder.setAttribute("data-rtl",this.options.rightToLeft)}createButtons(){["close","prev","next"].forEach((t=>{let e="close"===t?"closeShape":"arrowShape";this.markup[t].setAttribute("aria-label",this.options[`${t}Label`]),this.markup[t].appendChild(this.createSVG(this.options[e]))}))}createSVG=function(t){const e="http://www.w3.org/2000/svg",i=document.createElementNS(e,"svg"),s=document.createElementNS(e,"path");return i.setAttribute("viewBox","0 0 40 40"),s.setAttribute("d",t),i.appendChild(s),i};createMarkup(){this.markup.caption.appendChild(this.markup.title),this.markup.caption.appendChild(this.markup.desc),this.markup.figure.appendChild(this.markup.caption),["figure","counter","close","prev","next"].forEach((t=>{this.markup.holder.appendChild(this.markup[t])}))}counter(){this.markup.counter.textContent=this.options.counterMsg.replace("[index]",this.index+1).replace("[total]",this.items.length)}caption(){this.markup.caption.style.display=this.title||this.desc?"":"none",this.markup.title.innerHTML=this.title,this.markup.desc.innerHTML=this.desc}error(){const t=document.createElement("div");t.textContent=this.options.errorMsg,t.className="wpgb-lightbox-error",this.markup.figure.insertBefore(t,this.markup.caption)}prepare(){this.items.length<2?(this.markup.prev.style.display="none",this.markup.next.style.display="none"):(this.markup.prev.removeAttribute("style"),this.markup.next.removeAttribute("style"))}toggle(){let t=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];this.markup.holder.setAttribute("aria-hidden",String(!t))}loading(){let t=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];this.markup.holder.setAttribute("data-loading",t)}}class l{constructor(t,e,i){this.callback=i,this.source=e,this.type=t,this.loadMedia()}loadMedia(){switch(this.type){case"video":this.video();break;case"iframe":this.iframe();break;default:this.image()}}image(){this.media=new Image;const t="decode"in this.media;t||this.bindEvents(),this.media.src=this.source,this.isComplete()?this.onload(!0):t&&this.media.decode().then((()=>this.onload(!0))).catch((()=>this.onload(!1)))}video(){this.media=document.createElement("video"),this.media.setAttribute("controls",""),this.media.setAttribute("controlsList","nodownload"),this.bindEvents(),this.media.src=this.source}iframe(){this.media=document.createElement("iframe"),this.media.style.display="none",this.media.src=this.source,this.media.setAttribute("frameborder",0),this.media.setAttribute("allowfullscreen",""),this.bindEvents(),document.body.appendChild(this.media)}isComplete(){return this.media.complete&&this.media.naturalWidth}onload(t){this.media&&(this.media.removeAttribute("style"),this.callback(this.media,t),this.destroy())}bindEvents(){let t=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];t=t?"addEventListener":"removeEventListener",this.media[t]("loadedmetadata",this),this.media[t]("load",this),this.media[t]("error",this)}handleEvent(t){this.onload(!!t.type.match("load"))}removeMedia(){const{parentElement:t}=this.media;t&&"BODY"===t.tagName&&t.removeChild(this.media)}destroy(){this.media&&(this.bindEvents(!1),this.removeMedia(),this.callback=null,this.source=null,this.media=null,this.type=null)}}class d extends h{constructor(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};super(),this.options={...t,...e}}init(){this.create(),this.attach(),this.dragger()}attach(){this.onOpen=this.open.bind(this),document.addEventListener("click",this.onOpen,!0)}queryGallery(){let t=this.options.selector;this.gallery=this.item.getAttribute(this.options.relAttr),this.gallery&&""!==this.gallery&&(t+=`[${this.options.relAttr}="${this.gallery}"]`);try{this.items=[...document.querySelectorAll(t)]}catch(t){console.error(t)}}open(t){const e=t.target?t.target.closest(this.options.selector):null;e&&(t.preventDefault(),t.stopPropagation(),this.item=e,this.append(),requestAnimationFrame((()=>{setTimeout((()=>{this.emit("open",[this.item]),this.queryGallery(),this.prepare(),this.update(),this.toggle(),this.bindEvents()}),0)})))}close(t){this.toggle(!1),this.emit("close",[this.item])}next(){this.update(1)}previous(){this.update(-1)}modulo(t,e){return(e+t%e)%e}update(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:0;t&&this.items.length<2||(this.media&&"VIDEO"===this.media.nodeName&&this.media.pause(),this.media&&"IFRAME"===this.media.nodeName&&this.media.removeAttribute("src"),this.loading(!0),this.getItem(t),this.setAttr(),this.counter(),this.load())}getItem(t){this.index=t?this.modulo(this.index+t,this.items.length):this.items.findIndex((t=>t===this.item)),this.item=this.items[this.index]}setAttr(){this.source=this.item.href,this.title=(this.item.getAttribute("data-title")||"").trim(),this.desc=(this.item.getAttribute("data-desc")||"").trim(),this.type=(this.item.getAttribute("data-type")||"").trim(),this.emit("update",[this.item])}load(){this.loader&&this.loader.destroy(),this.emit("load",[this.item]),this.loader=new l(this.type,this.source,this.loaded.bind(this))}loaded(t,e){this.caption(),t.src===this.source&&(this.media=t,this.removeMedia(),e?this.markup.figure.insertBefore(this.media,this.markup.caption):this.error(),this.resize(),this.loading(!1),this.emit("loaded",[this.item]))}resize(){const t=this.markup.holder.clientWidth,e=this.markup.holder.clientHeight-88;let i=1280,s=720;"image"===this.type&&(i=this.media.naturalWidth,s=this.media.naturalHeight);const n=i/s;s=e-this.markup.caption.clientHeight,i=Math.min(i,t,n*s),this.markup.figure.style.width=i+"px",this.media.style.height=i/n+"px"}destroy(){document.removeEventListener("click",this.onOpen),this.close()}}class c extends e{constructor(){super(),this.vendors={},this.instances={}}get(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:0;const{instances:e}=this,i=[];if(!Object.keys(e).length)return[];for(const s in e)(e[s].id||"").toString()===t.toString()&&i.push(e[s]);return i}instance(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:0;return Object.keys(this.instances).length&&this.instances[t]?this.instances[t]:{}}}const p={get:()=>[],instance:()=>[],instances:()=>[],instantiate:()=>[],on:()=>null,off:()=>null,once:()=>null,offAll:()=>null,emit:()=>null,vendors:{},unsupported:!0};if(!window?.WP_Grid_Builder?.instance){const t=!!(Math.sign&&Array.from&&Array.prototype.fill&&Array.prototype.find&&Array.prototype.findIndex&&Array.prototype.includes&&Element.prototype.matches&&Element.prototype.closest&&NodeList.prototype.forEach&&window.Map&&window.URLSearchParams);window.WP_Grid_Builder=t?Object.assign(new c,window?.WP_Grid_Builder||{}):Object.assign(p,window?.WP_Grid_Builder||{})}WP_Grid_Builder.Lightbox=t=>new d(t),function(t){let e;"function"==typeof Event?e=new CustomEvent(t):(e=document.createEvent("CustomEvent"),e.initEvent(t,!0,!0)),window.dispatchEvent(e)}("wpgb.lightbox.loaded")})();