/*!
* WP Grid Builder
*
* @package   WP Grid Builder
* @author    Loïc Blascos
* @link      https://www.wpgridbuilder.com
* @copyright 2019-2024 Loïc Blascos
*
*/
(()=>{"use strict";const t={prefix:"",suffix:"",thousandsSeparator:"",decimalSeparator:".",decimalPlaces:0,rightToLeft:!1,resetRange:"",minLabel:"",maxLabel:""},e={};class i{constructor(){this.listeners=new Map}canListen(t,e){return!("function"!=typeof e||!t)||(!("object"!=typeof e||!e[t])||(console.error(`Invalid listener for event name: "${t}"`),!1))}exists(t,e){if(this.listeners.has(t))return this.listeners.get(t).find((t=>t.listener===e))}on(t,e){let i=arguments.length>2&&void 0!==arguments[2]&&arguments[2];return this.canListen(t,e)?(this.listeners.has(t)||this.listeners.set(t,[]),this.exists(t,e)||this.listeners.get(t).push({listener:e,once:i}),this):this}once(t,e){return this.on(t,e,!0)}off(t,e){const i=this.listeners.get(t)||[],s=i.findIndex((t=>t.listener===e));return s>-1&&i.splice(s,1),i.length<1&&this.listeners.delete(t),this}offAll(){return this.listeners.clear(),this}emit(t){for(var e=arguments.length,i=new Array(e>1?e-1:0),s=1;s<e;s++)i[s-1]=arguments[s];return[...this.listeners.get(t)||[]].forEach((e=>{e.once&&this.off(t,e.listener),"object"==typeof e.listener?e.listener[t].apply(e.listener,...i):e.listener.apply(this,...i)})),this}}let s=!1;try{let t=Object.defineProperty({},"passive",{get:()=>s=!0});window.addEventListener("test",null,t),window.removeEventListener("test",null,t)}catch(t){}class n extends i{attachPointers(t){this.pointer={},this.pointedElement=t,this.passiveListener=s,this._getEvents(),this._unifyEvents(),this._bindEvents()}_getEvents(){this.events={down:"mousedown",move:"mousemove",up:"mouseup"},window.PointerEvent?this.events={down:"pointerdown",move:"pointermove",up:"pointerup",cancel:"pointercancel"}:"ontouchstart"in window&&(this.events={down:"touchstart",move:"touchmove",up:"touchend",cancel:"touchcancel"})}_unifyEvents(){for(let t in this.events)this[`on${this.events[t]}`]=this._handleEvent}_bindEvents(){let t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];t=t?"add":"remove",(arguments.length>0&&void 0!==arguments[0]?arguments[0]:["down"]).forEach((e=>{("down"===e?this.pointedElement:window)[`${t}EventListener`](this.events[e],this,!!this.passiveListener&&{passive:!1})}))}handleEvent(t){const e="on"+t.type;this[e]&&this[e](t)}_handleEvent(t){if(this.isPointer(t)&&this.hasPointer(t))for(let e in this.events)if(this.events[e]===t.type)return this[`_pointer${e}`](t)}isPointer(t){return!t.button||t.button<1}hasPointer(t){const e=t.changedTouches||[t];for(let t=0;t<e.length;t++){let i=e[t].pointerId||e[t].identifier,s=this.pointer.pointerId||this.pointer.identifier;if(i===s||void 0===s)return this.pointer=e[t],!0}return!1}_pointerdown(t){this._bindEvents(["move","up","cancel"]),this._callBack("pointerDown",t)}_pointermove(t){this._callBack("pointerMove",t)}_pointerup(t){this._callBack("pointerUp",t),this._pointerDone(t)}_pointercancel(t){this._callBack("pointerCancel",t),this._pointerDone(t)}_pointerDone(t){this._callBack("pointerDone",t),this._pointerReset()}_pointerReset(){this._bindEvents(["move","up","cancel"],!1),this.pointer={}}_callBack(t,e,i){this[t]?this[t](e,this.pointer,i):this.emit(t,[e,this.pointer,i])}}const h={nodes:["TEXTAREA","SELECT","OPTION","INPUT"],types:["checkbox","radio","button","submit","image","file"]};class a extends n{drag(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{x:3,y:3},i=arguments.length>2&&void 0!==arguments[2]&&arguments[2];this.threshold=e,this.attachPointers(t),t.addEventListener("click",this),i&&window.addEventListener("touchmove",this.preventScrolling.bind(this),!!this.passiveListener&&{passive:!1})}canDragTarget(t){let{target:{nodeName:e,type:i}}=t;return!(h.nodes.includes(e)||h.types.includes(i))}canDragStart(t,e){const{x:i,y:s}=this.threshold,n=180*Math.atan2(Math.abs(e),Math.abs(t))/Math.PI,h=Math.sqrt(t**2+e**2);return!1!==i&&h>i&&n<=45||!1!==s&&h>s&&n>=45}canPreventDefault(t){let{type:e,pointerType:i}=t;return"touchstart"!==e&&"touch"!==i}getPointerVector(t){return{x:t.pageX-this.pointerStart.x,y:t.pageY-this.pointerStart.y}}pointerDown(t,e){this.preventClick=!1,this.canDragTarget(t)?(this.pointerStart={x:e.pageX,y:e.pageY},this.canPreventDefault(t)&&t.preventDefault(),this._callBack("dragDown",t)):this._pointerReset()}pointerMove(t,e){const{x:i,y:s}=this.getPointerVector(e);this.dragging?(t.preventDefault(),this._callBack("dragMove",t,{x:i,y:s})):this.canDragStart(i,s)&&(this.pointerStart.x+=i,this.pointerStart.y+=s,this.preventClick=!0,this.dragging=!0,this._callBack("dragStart",t,this.getPointerVector(e)))}pointerUp(t,e){this.dragging&&this._callBack("dragEnd",t,this.getPointerVector(e))}pointerCancel(t,e){this.dragging&&this._callBack("dragCancel",t,this.getPointerVector(e))}pointerDone(t,e){this._callBack("dragUp",t,this.getPointerVector(e)),this.dragging&&(this.dragging=!1,this._callBack("dragDone",t,this.getPointerVector(e)))}onclick(t){this.preventClick&&t.preventDefault()}preventScrolling(t){this.dragging&&t.preventDefault()}}class r extends a{initDragger(){this.drag(this.element)}dragDown(t,e,i){delete this.input,t.target===this.thumbs[0]?(this.input=this.inputs[0],this.thumb=this.thumbs[0],this.minVal=this.min,this.maxVal=parseFloat(this.inputs[1].value)):t.target===this.thumbs[1]&&(this.input=this.inputs[1],this.thumb=this.thumbs[1],this.minVal=parseFloat(this.inputs[0].value),this.maxVal=this.max),this.input?(!this.slider.width&&this.getSliderSize(),this.valStart=parseFloat(this.input.value),this.thumb.focus({preventScroll:!0})):this.thumb&&this.thumb.blur()}dragMove(t,e,i){const{x:s}=i,n=this.options.rightToLeft?-1:1;if(!this.input)return;let h=this.valStart+s*n*this.slider.factor;h=Math.min(this.maxVal,h),h=Math.max(this.minVal,h),this.input.step=h===this.max?this.max-this.min:this.step,this.input.value=h,this.dispatchEvent("input")}dragUp(t,e,i){if(this.input||Math.abs(i.x)>3)return;const s=this.element.querySelector(".wpgb-range-slider");(this.input||t.target===this.progress||t.target===s)&&(!this.slider.width&&this.getSliderSize(),this.getClosestThumb(e.clientX),0===i.x&&this.dragDone())}dragDone(t,e,i){this.input&&!this.input.disabled&&this.dispatchEvent("change")}dragEnd(t,e,i){}dragStart(t,e,i){}dragCancel(t,e,i){}}Math.max,Math.min;class l extends r{bindEvents(){let t=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];t=t?"addEventListener":"removeEventListener",window[t]("resize",this),this.keyCodes={},this.inputs.forEach(((e,i)=>{e[t]("input",this),e[t]("change",this),this.thumbs[i][t]("keydown",this),this.thumbs[i][t]("keyup",this)}))}oninput(){this.updateSlider()}onchange(){this.updateSlider()}onkeydown(t){const{thumbs:e,inputs:i}=this,{keyCode:s,target:n}=t,h=parseFloat(this.step||1);clearTimeout(this.timer),this.input=e[0]===n?i[0]:i[1];let a=parseFloat(this.input.value);37===s?this.input.value=a-h:39===s&&(this.input.value=a+h),this.updateSlider(),this.keyCodes[s]=!0,this.timer=setTimeout((()=>{!this.keyCodes[s]&&this.dispatchEvent("change")}),500)}onkeyup(t){this.keyCodes[t.keyCode]=!1}onresize(){this.getSliderSize(),this.updateSlider()}onclick(t){this.thumbs[0]!==t.target&&this.thumbs[1]!==t.target?this.reset===t.target&&(parseFloat(this.inputs[0].value)===parseFloat(this.min)&&parseFloat(this.inputs[1].value)===parseFloat(this.max)||(this.inputs[0].type="text",this.inputs[1].type="text",this.inputs[0].value="",this.inputs[1].value="",this.input=this.inputs[0],this.dispatchEvent("change"),this.inputs[0].type="range",this.inputs[1].type="range",this.inputs[0].value=this.min,this.inputs[1].value=this.max,this.input=this.inputs[0],this.previous=[this.inputs[0].value,this.inputs[1].value],this.updateSlider())):t.target.focus()}}class o extends l{appendSlider(){this.createSlider(),this.slider.insertBefore(this.progress,this.slider.firstElementChild),this.element.appendChild(this.slider),this.element.appendChild(this.values),this.reset&&this.element.appendChild(this.reset)}createSlider(){this.createElements(),this.createThumbs(),this.createButton()}createElements(){["slider","progress","values"].forEach((t=>{this[t]=document.createElement("values"===t?"span":"div"),this[t].className=`wpgb-range-${t}`}))}createThumbs(t){const e=document.createElement("div");this.thumbs=[this.createThumb(this.inputs[0]),this.createThumb(this.inputs[1])],this.thumbs[0].setAttribute("aria-label",this.options.minLabel),this.thumbs[1].setAttribute("aria-label",this.options.maxLabel),e.className="wpgb-range-thumbs",e.appendChild(this.thumbs[0]),e.appendChild(this.thumbs[1]),this.slider.appendChild(e)}createThumb(t){const e=document.createElement("div");return e.className="wpgb-range-thumb",e.tabIndex=0,e.setAttribute("role","slider"),e.setAttribute("aria-valuemin",t.min),e.setAttribute("aria-valuemax",t.max),e}createButton(t){this.options.resetRange&&(this.reset=document.createElement("button"),this.reset.type="button",this.reset.className="wpgb-range-clear",this.reset.textContent=this.options.resetRange)}}let u=0;class p extends o{constructor(e){let i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};super(),this.element=e,this.options={...t,...i};const s=this.setInstance();if(s)return s;this.inputs=this.element.querySelectorAll('input[type="range"]'),this.previous=[this.inputs[0].value,this.inputs[1].value],this.inputs&&this.init()}setInstance(){const{instance:t}=this.element;if(e[t])return e[t];this.instance=++u-1,this.element.instance=this.instance,e[this.instance]=this}init(){this.setValues(),this.appendSlider(),this.getSliderSize(),this.updateSlider(),this.bindEvents(),this.initDragger(),this.inputs[0].disabled&&this.disable()}destroy(){this.bindEvents(!1),this.slider.parentElement&&this.slider.parentElement.removeChild(this.slider),this.reset.parentElement&&this.reset.parentElement.removeChild(this.reset),this.values.parentElement&&this.values.parentElement.removeChild(this.values),delete e[this.instance],delete this.element.instance,delete this.instance}enable(){this.thumbs[0].hasAttribute("aria-disabled")&&(this.reset&&(this.reset.disabled=!1),this.inputs[0].disabled=!1,this.inputs[1].disabled=!1,this.thumbs[0].removeAttribute("aria-disabled"),this.thumbs[1].removeAttribute("aria-disabled"),this.bindEvents(),this.updateSlider())}disable(){this.thumbs[0].hasAttribute("aria-disabled")||(this.reset&&(this.reset.disabled=!0),this.inputs[0].disabled=!0,this.inputs[1].disabled=!0,this.thumbs[0].setAttribute("aria-disabled","true"),this.thumbs[1].setAttribute("aria-disabled","true"),this.bindEvents(!1))}setValues(){this.step=parseFloat(this.inputs[0].step),this.min=parseFloat(this.inputs[0].min),this.max=parseFloat(this.inputs[0].max)}getSliderSize(t){const{left:e,right:i,width:s}=this.element.getBoundingClientRect(),{rightToLeft:n}=this.options,{min:h,max:a}=this;this.thumbWidth=this.thumbs[0].offsetWidth||16,this.slider={posX:n?i:e,width:s,factor:(a-h)/(s-this.thumbWidth)}}getPointerValue(t){const{posX:e,factor:i}=this.slider,{rightToLeft:s}=this.options,{min:n,max:h}=this;return(s?-1:1)*(t-e)*i+n}getThumbPosition(t){let{value:e,min:i,max:s}=t;return(e-i)/(s-i)*100}getClosestThumb(t){const{inputs:e,thumbs:i}=this,{rightToLeft:s}=this.options,n=this.getPointerValue(t-this.thumbWidth/2*(s?-1:1)),h=e[0].value,a=e[1].value;this.input=e[0],this.thumb=i[0],n-h>a-n&&(this.input=e[1],this.thumb=i[1]),this.input.step=this.step,this.input.value=n}updateProgress(){const{inputs:t,thumbs:e}=this,{rightToLeft:i}=this.options,s=t[0].max-t[0].min,n=this.getThumbPosition(t[0])||0,h=this.getThumbPosition(t[1])||0,a=(h-n)/100,r=i?"right":"left",l=i?100-h:n;this.progress.style.transform=`translate(${l}%, 0) scale(${a}, 1)`,e[0].style[r]=`${n}%`,e[1].style[r]=`${h}%`,e[0].setAttribute("aria-valuenow",t[0].value),e[1].setAttribute("aria-valuenow",t[1].value),t[1].value/s*100>50?e[1].style.zIndex=1:e[1].style.zIndex=""}updateValues(){const{thumbs:t,inputs:e}=this,{prefix:i,suffix:s}=this.options,n=this.formatNumber(Math.min(e[0].value,e[1].value)),h=this.formatNumber(Math.max(e[0].value,e[1].value)),a=`${i+n+s}`,r=`${i+h+s}`;let l=`${a} - ${r}`;n===h&&(l=a),this.values.textContent=l,t[0].setAttribute("aria-valuetext",a),t[1].setAttribute("aria-valuetext",r)}dispatchEvent(t){let e;this.hasChanged(t)&&("function"==typeof Event?e=new Event(t,{bubbles:!0}):(e=document.createEvent("Event"),e.initEvent(t,!0,!0)),this.input.dispatchEvent(e))}hasChanged(t){return"change"!==t||(this.inputs[0].value!==this.previous[0]||this.inputs[1].value!==this.previous[1])&&(this.previous=[this.inputs[0].value,this.inputs[1].value],!0)}updateSlider(){this.updateProgress(),this.updateValues(),this.reset&&(this.reset.disabled=parseFloat(this.inputs[0].value)===parseFloat(this.min)&&parseFloat(this.inputs[1].value)===parseFloat(this.max))}formatNumber(t){let{decimalPlaces:e,decimalSeparator:i,thousandsSeparator:s}=this.options,n=this.step.toString().split(".");n=n[1]?[...n[1]].length:0,e=isFinite(+e)?Math.abs(e):0,e=Math.max(n,e),t=isFinite(+t)?+t:0;let h=(t=e?this.toFixed(t,e):Math.round(t)).toString().split(".");return h[0].length>3&&(h[0]=h[0].replace(/\B(?=(?:\d{3})+(?!\d))/g,s)),(h[1]||"").length<e&&(h[1]=h[1]||"",h[1]+=new Array(e-h[1].length+1).join("0")),h.join(i)}toFixed(t,e){const i=Math.pow(10,e);return Math.round(t*i)/i}}window.WP_Grid_Builder||(window.WP_Grid_Builder={vendors:{}}),WP_Grid_Builder.vendors.range=(t,e)=>new p(t,e)})();