/*!
* WP Grid Builder
*
* @package   WP Grid Builder
* @author    Loïc Blascos
* @link      https://www.wpgridbuilder.com
* @copyright 2019-2024 Loïc Blascos
*
*/
(()=>{"use strict";const e={searchable:!0,clearable:!0,clearLabel:"Clear Selection",toggleLabel:"Toggle List",clearShape:"m12 12-4.25 4.75L12.001 12 7.75 7.25 12.001 12l4.249-4.75L12 12l4.25 4.75Z",toggleShape:"m12 14.536-.045.043.045-.043-5.3-5.114 5.3 5.114 5.3-5.114-5.3 5.114.045.043Z",messages:{loading:"Loading...",search:"Please enter 1 or more characters.",noResults:"No Results Found.",selected:"option %s, selected.",deselected:"option %s, deselected.",cleared:"options cleared.",expanded:"Use Up and Down to choose options, press Enter to select the currently focused option, press Escape to collapse the list.",collapsed:"Press Enter or Space to expand the list."},async:{url:"",data:"",post:"",response:""}},t={};class s{dispatchEvent(e){let t;"function"==typeof Event?t=new Event(e,{bubbles:!0}):(t=document.createEvent("Event"),t.initEvent(e,!0,!0)),this.element.dispatchEvent(t)}handleEvent(e){const t="on"+e.type;this[t]&&this[t](e)}isBind(){return!(arguments.length>0&&void 0!==arguments[0])||arguments[0]?"addEventListener":"removeEventListener"}selectEvents(){let e=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];e=this.isBind(e),this.element[e]("change",this),this.element[e]("focus",this),this.DOM.select[e]("keydown",this),this.DOM.select[e]("click",this),this.DOM.search[e]("focus",this),this.DOM.search[e]("blur",this),this.DOM.search[e]("input",this),this.DOM.search[e]("change",this),window[e]("mousedown",this)}dropDownEvents(){let e=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];e=this.isBind(e),window[e]("resize",this),window[e]("keydown",this),this.DOM.dropDown[e]("click",this),this.DOM.dropDown[e]("mousemove",this)}onfocus(e){e.currentTarget===this.element?this.toggle():this.DOM.focus()}onblur(e){this.DOM.blur(),this.close()}onmousedown(e){const{target:t}=e,s=t&&t.closest(".wpgb-select-dropdown"),i=t&&t.closest(".wpgb-select"),o=e.toElement&&e.toElement.control;t===this.DOM.search&&this.DOM.search.value||o!==this.element&&i!==this.DOM.select&&s!==this.DOM.dropDown||e.preventDefault()}onmousemove(e){const t=e.target.closest(".wpgb-select-item");t&&this.DOM.highlight(t)}onkeydown(e){e.currentTarget===this.DOM.select?this.selectNavigation(e):this.dropDownNavigation(e)}onclick(e){const{target:t,currentTarget:s}=e,i=t.closest(".wpgb-select-remove"),o=t.closest(".wpgb-select-clear"),n=t.closest(".wpgb-select-item");s===this.DOM.select?o?(this.close(),this.clear()):i?this.remove(i.index):this.DOM.search.value&&t===this.DOM.search||this.toggle():n&&this.select(n.index)}selectNavigation(e){const{search:t,focused:s}=this.DOM,{target:i}=e,o=i&&i.closest(".wpgb-select-remove");switch(e.keyCode){case 27:this.close();break;case 13:o?this.remove(o.index):this.opened?s&&this.select(s.index):this.toggle();break;case 8:const{selection:i}=this.Data,{options:n}=this.element;if(!this.options.clearable&&!this.multiple)return;if(!this.multiple&&n.length&&n[0].value)return;!this.DOM.search.value&&i.length&&this.remove(i.pop().index);break;case 32:t.value||(e.preventDefault(),this.toggle())}}dropDownNavigation(e){const{items:t,focused:s}=this.DOM,{length:i}=t;let o=t.indexOf(s);switch(e.keyCode){case 38:o=Math.max(--o,0);break;case 40:o=Math.min(++o,i-1);break;case 35:o=i-1;break;case 36:o=0;break;default:return}t[o]&&(e.preventDefault(),this.DOM.highlight(t[o]),this.DOM.scrollList())}oninput(e){if(e.preventDefault(),e.stopPropagation(),!this.opened&&!this.DOM.search.value)return;this.opened||this.open();const t=this.Data.normalize(this.DOM.search.value,!0);this.DOM.searchValue!==t&&(this.DOM.searchValue=t,this.setWidth(),this.DOM.togglePlaceholder(),this.DOM.assertive.textContent="",this.options.async?(this.xhr&&this.xhr.abort(),clearTimeout(this.timeout),this.Data.options=[],this.Data.loading=!!t,this.DOM.clearDropDown(),t&&(this.timeout=setTimeout((()=>this.load()),250))):this.search())}search(){const e=this.DOM.createList(),t=this.results&&e.isEqualNode(this.results);!this.options.async&&t||(this.results=e,this.DOM.refreshDropDown(e),this.DOM.search.value?this.DOM.dropDown.scrollTop=0:this.DOM.scrollList(!0))}appendOptions(){this.element.options[0];const e=this.Data.selection||{},t=[];e.forEach((e=>{t[e.value]=e})),this.Data.options&&this.Data.options.map(((e,s)=>(e.index=s,e.selected=!!t[e.value],e)))}load(){const e=new URLSearchParams;let{url:t,data:s,post:i,response:o,header:n,contentType:l}=this.options.async;s=s&&s(this.DOM.search.value),void 0===this.xhr&&(this.xhr=new XMLHttpRequest);for(let t in s)e.set(t,s[t]);if(t=e.toString()?`${t}?${e.toString()}`:t,this.xhr.onload=e=>{let{responseText:t}=e.target;try{t=JSON.parse(t)}catch(e){t=""}this.Data.options=o?o(t):t,this.Data.loading=!1,this.appendOptions(),this.search()},this.xhr.open("POST",t,!0),l&&this.xhr.setRequestHeader("Content-Type",l),Object.values(n||{})?.length)for(const e in n)n[e]&&this.xhr.setRequestHeader(e,n[e]);setTimeout((()=>this.xhr.send(i&&i(this.DOM.search.value))))}setWidth(){const e=this.DOM.select.clientHeight;this.DOM.sizer.textContent=this.DOM.search.value,this.DOM.search.style.width=this.DOM.sizer.clientWidth+5+"px",this.DOM.search.value.length||this.DOM.search.removeAttribute("style"),this.DOM.select.clientHeight!==e&&this.DOM.sizeDropDown()}onchange(e){e.target===this.DOM.search?(e.preventDefault(),e.stopPropagation()):this.update()}onresize(){this.close()}}class i{constructor(e,t){this.element=e,this.settings=t}parse(){this.options=this.getOptions(this.element)}getOptions(e){let t=[];return e.children&&(e=e.children),Array.from(e).forEach((e=>{let{tagName:s,value:i,index:o,textContent:n,selected:l,disabled:h}=e;"OPTGROUP"!==s?(0!==o||i||(e.selected=!1),t.push({value:i,index:o,textContent:n,selected:l,disabled:h})):t.push({label:e.label,children:this.getOptions(e)})})),t}getSelection(){const{options:e}=this.element;this.selection=Array.from(e).filter((e=>e.selected))}normalize(e,t){return String.prototype.normalize&&(e=e.normalize("NFD").replace(/[\u0300-\u036f]/g,"")),t&&(e=e.replace(/[.*+?^${}()|[\]\\]/g,"\\$&")),this.settings.async?e.toLowerCase().replace(/\s\s+/g," "):e.toLowerCase().trim()}}class o{constructor(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};this.options=e}createEl(e,t,s){const i=document.createElement(e);if(t)for(let e of Object.keys(t))void 0!==i[e]?i[e]=t[e]:i.hasAttribute(e)||i.setAttribute(e,t[e]);return s&&(i.textContent=s),i}select(){return this.createEl("div",{class:"wpgb-select"})}placeholder(){return this.createEl("div",{class:"wpgb-select-placeholder",role:"combobox","aria-haspopup":!0,"aria-expanded":!1})}dropDown(){return this.createEl("div",{class:"wpgb-select-dropdown"})}noFounds(){return this.createEl("div",{class:"wpgb-select-noresults"},"No Options Found")}label(e,t){return this.createEl("label",{class:"wpgb-select-sr-only",id:`wpgb-select-label-${e}`,for:`wpgb-select-${e}`},t)}search(e){return this.createEl("input",{id:`wpgb-select-${e}`,tabindex:0,type:"text",placeholder:"",spellcheck:!1,autocomplete:"off",autocapitalize:"none","aria-autocomplete":"list"})}assertive(){return this.createEl("div",{class:"wpgb-select-sr-only",role:"status","aria-live":"polite","aria-atomic":!0})}item(e,t){return this.createEl("li",{id:`wpgb-select-item-${t}`,class:"wpgb-select-item",role:"option",tabindex:-1,"aria-selected":e.selected,"aria-disabled":e.disabled},e.textContent)}group(e){return this.createEl("li",{class:"wpgb-select-group",role:"group","aria-labelledby":`wpgb-select-group-${e.uid}`})}heading(e){return this.createEl("div",{class:"wpgb-select-label",role:"heading"},e.label)}list(e,t){return this.createEl("ul",{role:"listbox",tabindex:-1,"aria-labelledby":`wpgb-select-label-${t}`,"aria-multiselectable":e})}value(e){const t=this.button("remove","remove"),s=this.svg(this.options.clearShape),i=document.createElement("span"),o=this.createEl("div",{class:"wpgb-select-value"});return i.textContent=e,t.appendChild(s),o.appendChild(i),o.appendChild(t),o}button(e,t){return this.createEl("button",{class:`wpgb-select-${e}`,type:"button",tabindex:-1,"aria-label":t})}loader(){const e=this.createEl("div",{class:"wpgb-select-loader",type:"div"});return[1,2,3].forEach((()=>e.appendChild(this.createEl("span")))),e}svg(e){const t="http://www.w3.org/2000/svg",s=document.createElementNS(t,"svg"),i=document.createElementNS(t,"path");return i.setAttribute("d",e),s.setAttribute("viewBox","0 0 24 24"),s.setAttribute("aria-hidden",!0),s.setAttribute("focusable",!1),s.appendChild(i),s}}class n{createDropDown(){this.list=this.createList(),this.list.id="wpgb-select-results",this.dropDown=this.components.dropDown(),this.dropDown.appendChild(this.list)}appendDropDown(){this.updateDropDown(),document.body.appendChild(this.dropDown)}removeDropDown(){this.dropDown.parentElement&&this.dropDown.parentElement.removeChild(this.dropDown)}refreshDropDown(e){this.updateDropDown(),this.dropDown.replaceChild(e,this.dropDown.lastElementChild)}clearDropDown(){this.list=this.createList(),this.dropDown.replaceChild(this.list,this.dropDown.lastElementChild)}updateDropDown(){const{options:e}=this.element;delete this.focused,this.items.forEach((t=>{let s=e[t.index]||{};this.options.async&&(s=this.Data.options[t.index]||{}),t.classList.remove("wpgb-focused"),t.setAttribute("aria-selected",s.selected),s.selected&&!this.focused&&(this.focused=t)})),this.focused&&!this.searchValue||(this.focused=this.items[0]),this.focused&&this.focused.classList.add("wpgb-focused"),this.dropDown.parentElement&&this.search.setAttribute("aria-activedescendant",this.focused&&this.focused.id||"")}createList(){this.uid=0,this.items=[],this.focused=!1;const e=this.createItems(this.Data.options),{search:t,loading:s,noResults:i}=this.options.messages,{async:o}=this.options;if(e.firstChild)this.assertive&&this.assertive.parentElement&&(this.assertive.textContent="");else{const n=document.createElement("li");let l=i;n.className="wpgb-select-noresults",o&&!this.search.value?l=t:o&&this.Data.loading&&(l=s),this.assertive.textContent=l,n.textContent=l,e.appendChild(n)}return this.toggleLoader(),e}createItems(e){const t=this.components.list(this.multiple,this.instance);return e&&e.forEach((e=>{if(e.children){let s=this.createGroup(e);return void(s&&t.appendChild(s))}let s=this.createItem(e);s&&t.appendChild(s)})),t}createItem(e){let t=this.components.item(e,e.index);if(e.value&&this.optionExists(e))return e.selected&&!this.focused&&(this.focused=t),e.disabled||this.items.push(t),t.index=e.index,t.disabled=e.disabled,t}createGroup(e){e.uid=++this.uid;let t=this.createItems(e.children);if(t.childElementCount){let s=this.components.group(e),i=this.components.heading(e);return s.appendChild(i),s.appendChild(t),s}}optionExists(e){return!!this.options.async||(!this.searchValue||(this.Data.normalize(e.textContent).search(this.searchValue)>-1||void 0))}scrollList(e){if(!this.focused)return;const t=this.dropDown.getBoundingClientRect(),s=this.focused.getBoundingClientRect(),i=s.top-t.top+s.height;e?this.dropDown.scrollTop+=s.top-t.top+s.height/2-t.height/2:i>t.height?this.dropDown.scrollTop+=i-t.height:i<s.height&&(this.dropDown.scrollTop+=i-s.height)}sizeDropDown(){const{top:e,bottom:t,left:s,width:i}=this.select.getBoundingClientRect(),{style:o}=this.dropDown;o.top=t+window.pageYOffset+"px",o.left=s+"px",o.width=i+"px",o.position="absolute",o.display="block"}highlight(e){e&&!e.disabled&&this.focused&&e!==this.focused&&(this.focused.classList.remove("wpgb-focused"),this.focused=e,this.focused.classList.add("wpgb-focused"),this.search.setAttribute("aria-activedescendant",e.id))}}class l extends n{constructor(e,t){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};super(),this.Data=t,this.options=s,this.element=e,this.instance=e.instance,this.multiple=e.multiple,this.components=new o(this.options)}create(){this.createHolders(),this.createSearch(),this.createInput(),this.createDropDown(),this.createControls()}append(){const e=this.element.closest("label");this.select.appendChild(this.placeholder),this.select.appendChild(this.controls),e?e.parentNode.insertBefore(this.select,e.nextSibling):this.element.parentNode.insertBefore(this.select,this.element.nextSibling)}remove(){this.select.parentElement.removeChild(this.select),this.element.classList.remove("wpgb-select-sr-only")}hide(){this.element.classList.add("wpgb-select-sr-only"),this.element.setAttribute("tabindex",-1),this.element.setAttribute("aria-hidden",!0)}reveal(){this.element.style.display="",this.element.removeAttribute("tabindex"),this.element.removeAttribute("aria-hidden")}expand(){let e=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];this.list.setAttribute("aria-expanded",e),this.placeholder.setAttribute("aria-expanded",e),e?(this.search.focus(),this.placeholder.setAttribute("aria-owns","wpgb-select-results"),this.search.setAttribute("aria-activedescendant",this.focused&&this.focused.id),this.assertive.textContent=this.options.messages.expanded):(this.search.removeAttribute("style"),this.placeholder.removeAttribute("aria-owns"),this.search.removeAttribute("aria-activedescendant"))}focus(){this.select.classList.add("wpgb-select-focused"),this.assertive.textContent=this.options.messages.collapsed}blur(){this.select.classList.remove("wpgb-select-focused"),this.assertive.textContent=""}createHolders(){this.select=this.components.select(),this.placeholder=this.components.placeholder()}createControls(){const{toggleLabel:e,clearLabel:t,toggleShape:s,clearShape:i}=this.options;this.controls=document.createElement("div"),this.controls.className="wpgb-select-controls",this.separator=document.createElement("span"),this.separator.className="wpgb-select-separator",this.toggleButton=this.components.button("toggle",e),this.clearButton=this.components.button("clear",t),this.loader=this.components.loader(),this.toggleButton.appendChild(this.components.svg(s)),this.clearButton.appendChild(this.components.svg(i)),this.controls.appendChild(this.separator),this.controls.appendChild(this.toggleButton)}createSearch(){this.input=document.createElement("div"),this.sizer=document.createElement("div"),this.search=this.components.search(this.element.instance),this.label=this.components.label(this.element.instance,this.getLabel()),this.assertive=this.components.assertive(),this.input.className="wpgb-select-search",this.options.searchable||(this.search.readOnly=!0),this.input.appendChild(this.assertive),this.input.appendChild(this.label),this.input.appendChild(this.search),this.input.appendChild(this.sizer)}getLabel(){const e=this.element.closest("label"),t=e&&e.firstElementChild;return t&&t.textContent||"select content"}createInput(){this.multiple?(this.selection=document.createElement("div"),this.selection.className="wpgb-select-values",this.selection.appendChild(this.input),this.placeholder.appendChild(this.selection)):(this.selectValue=document.createElement("span"),this.selectValue.className="wpgb-select-value",this.placeholder.appendChild(this.input))}setSelection(){const{selection:e}=this.Data;if(this.multiple){this.removeSelection();const t=document.createDocumentFragment();e.forEach((e=>{let s=this.components.value(e.textContent.trim());s.lastElementChild.index=e.index,t.appendChild(s)})),this.selection.insertBefore(t,this.input)}else e[0]&&e[0].value?(this.selectValue.textContent=e[0].textContent.trim(),this.placeholder.insertBefore(this.selectValue,this.input)):this.selectValue.parentElement&&this.placeholder.removeChild(this.selectValue);this.addPlaceholder(),this.addClear()}removeSelection(e){for(;this.selection.firstElementChild!==this.input;)this.selection.removeChild(this.selection.firstElementChild)}addPlaceholder(){const{selection:e}=this.Data,{options:t}=this.element,{length:s}=e;!s&&t.length&&!t[0].value||1===s&&!e[0].value?this.search.placeholder=t[0]&&t[0].textContent||"":this.search.placeholder=""}togglePlaceholder(){const{selection:e}=this.Data;this.multiple||(this.searchValue&&this.selectValue.parentElement?this.placeholder.removeChild(this.selectValue):!this.searchValue&&e[0]&&e[0].value&&this.placeholder.insertBefore(this.selectValue,this.input))}toggleLoader(){this.options.async&&(this.Data.loading?(!this.loader.parentElement&&this.controls.insertBefore(this.loader,this.separator),this.clearButton&&this.clearButton.parentElement&&this.controls.removeChild(this.clearButton)):(this.loader&&this.loader.parentElement&&this.controls.removeChild(this.loader),this.clearButton&&this.addClear()))}addClear(){const{selection:e}=this.Data,{options:t}=this.element;this.options.clearable&&(t[0]&&t[0].value&&!this.multiple||(e.length>0&&e[0].value?this.controls.insertBefore(this.clearButton,this.separator):this.clearButton.parentElement&&this.controls.removeChild(this.clearButton)))}}let h=0;class a extends s{constructor(t){let s=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};super(),this.element=t,this.multiple=t.multiple,this.options={...e,...s},this.options.async.url||(this.options.async=0),this.options.async&&(this.options.searchable=1)}setInstance(){const{instance:e}=this.element;if(t[e])return t[e];this.instance=++h-1,this.element.instance=this.instance,t[this.instance]=this}init(){const e=this.setInstance();if(e)return e;this.Data=new i(this.element,this.options),this.DOM=new l(this.element,this.Data,this.options),this.options.async||this.Data.parse(),this.DOM.create(),this.DOM.append(),this.DOM.hide(),this.element.disabled?this.disable():this.selectEvents(),this.update()}destroy(){this.close(),this.DOM.remove(),this.DOM.reveal(),this.selectEvents(!1),document.activeElement===this.select&&this.element.focus(),delete t[this.instance],delete this.element.instance,delete this.instance}enable(){this.DOM.search.disabled&&(this.DOM.select.classList.remove("wpgb-select-disabled"),this.DOM.search.disabled=!1,this.selectEvents())}disable(){this.DOM.search.disabled||(this.DOM.select.classList.add("wpgb-select-disabled"),this.DOM.search.disabled=!0,this.selectEvents(!1),this.close())}focus(){const{search:e}=this.DOM;document.activeElement!==e&&e.focus()}blur(){const{search:e}=this.DOM;document.activeElement===e&&e.blur()}open(){this.opened||(this.DOM.appendDropDown(),this.DOM.sizeDropDown(),this.DOM.scrollList(!0),this.DOM.expand(!0),this.dropDownEvents(!0),this.opened=!0)}close(){this.opened&&(this.DOM.expand(!1),this.DOM.removeDropDown(),this.options.async&&(this.Data.options=[],this.Data.loading=!1,this.xhr&&this.xhr.abort(),clearTimeout(this.timeout),this.DOM.clearDropDown()),this.DOM.search.value&&this.reset(),this.DOM.togglePlaceholder(),this.dropDownEvents(!1),this.opened=!1)}toggle(){this.opened?this.close():this.open()}reset(){delete this.results,delete this.DOM.searchValue,this.DOM.search.value="",this.DOM.sizer.textContent="",this.DOM.createDropDown()}update(){this.Data.getSelection(),this.options.async&&this.appendOptions(),this.DOM.updateDropDown(),this.DOM.setSelection(),this.DOM.sizeDropDown()}select(e){const{options:t}=this.element;let s=t[e];this.options.async&&(s=this.addOption(e)),s&&!s.disabled&&(s.selected=s&&!s.selected,this.DOM.assertive.textContent=this.options.messages.selected.replace("%s",s.textContent),this.dispatchEvent("change"),this.close())}addOption(e){const t=this.Data.selection||{},s=this.Data.options||{},i=document.createElement("option");let o=s[e];return o?o&&o.selected?(t.forEach((e=>{e.value!==o.value||this.element.remove(e.index)})),o):(i.value=o.value,i.selected=!0,i.textContent=o.textContent,this.element.add(i),o):{}}remove(e){const{options:t}=this.element,s=t[e];s&&(0!==e||s.value)&&(s.selected=!1,this.DOM.assertive.textContent=this.options.messages.deselected.replace("%s",s.textContent),this.options.async&&this.element.remove(e),this.dispatchEvent("change"),this.DOM.scrollList(!0),this.focus())}clear(){const{selection:e}=this.Data;e.length&&(Array.from(this.element.options).forEach((e=>{let t=""===e.value&&!e.index;e.selected=!1,this.options.async&&!t&&this.element.remove(e.index)})),this.DOM.assertive.textContent=this.options.messages.cleared,this.dispatchEvent("change"),this.focus())}}window.WP_Grid_Builder||(window.WP_Grid_Builder={vendors:{}}),WP_Grid_Builder.vendors.select=(e,t)=>new a(e,t)})();